# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from TestUnit.idl.

use strict;

package Raritan::RPC::test::Unit_2_0_0;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "test.Unit:2.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::test::Unit_2_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}


sub getDisplays($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDisplays', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'test.Display');
    }
    return $_ret_;
}

sub getButtonStates($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getButtonStates', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = ($rsp->{'_ret_'}->[$i0]) ? 1 : 0;
    }
    return $_ret_;
}

sub setBuzzer($$) {
    my ($self, $isOn) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'isOn'} = ($isOn) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setBuzzer', $args);
}

sub resetAllSubControllers($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'resetAllSubControllers', $args);
}

sub triggerSubControllerWatchdog($$) {
    my ($self, $rs485Addr) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rs485Addr'} = 1 * $rs485Addr;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'triggerSubControllerWatchdog', $args);
}

Raritan::RPC::Registry::registerProxyClass('test.Unit', 2, 0, 0, 'Raritan::RPC::test::Unit_2_0_0');
1;
