/**
 *  @file IoapicReg.h
 *  @brief This file contains Ioapic Register definitions
 */

/* Copyright 2022-2023 Advanced Micro Devices, Inc. All rights reserved.    */
// SPDX-License-Identifier: MIT

#pragma once

#define IOAPIC_BR_INTERRUPT_ROUTING_Br_ext_Intr_grp_OFFSET      0
#define IOAPIC_BR_INTERRUPT_ROUTING_Br_ext_Intr_grp_MASK        0x7
#define IOAPIC_BR_INTERRUPT_ROUTING_Br_ext_Intr_swz_OFFSET      4
#define IOAPIC_BR_INTERRUPT_ROUTING_Br_ext_Intr_swz_MASK        0x30
#define IOAPIC_BR_INTERRUPT_ROUTING_Br_ext_Intr_map_OFFSET      16
#define IOAPIC_BR_INTERRUPT_ROUTING_Br_ext_Intr_map_MASK        0x1f0000

#define SMN_IOHUB0_N0NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x14300040UL
#define SMN_IOHUB0_N1NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x14300044UL
#define SIL_RESERVED_618                                           0x14300048UL
#define SMN_IOHUB0_N3NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x1430004cUL
#define SMN_IOHUB0_N4NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x14300050UL
#define SMN_IOHUB0_N5NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x14300054UL
#define SIL_RESERVED_719                                           0x14300058UL
#define SMN_IOHUB0_N7NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x1430005cUL
#define SMN_IOHUB0_N8NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x14300060UL
#define SMN_IOHUB0_N9NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS     0x14300064UL
#define SMN_IOHUB0_N10NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300068UL
#define SMN_IOHUB0_N11NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x1430006cUL
#define SMN_IOHUB0_N12NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300070UL
#define SMN_IOHUB0_N13NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300074UL
#define SMN_IOHUB0_N14NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300078UL
#define SMN_IOHUB0_N15NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x1430007cUL
#define SMN_IOHUB0_N16NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300080UL
#define SMN_IOHUB0_N17NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300084UL
#define SMN_IOHUB0_N18NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300088UL
#define SMN_IOHUB0_N19NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x1430008cUL
#define SMN_IOHUB0_N20NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300090UL
#define SMN_IOHUB0_N21NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300094UL
#define SMN_IOHUB0_N22NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x14300098UL
#define SMN_IOHUB0_N23NBIO0_IOAPIC_BR_INTERRUPT_ROUTING_ADDRESS    0x1430009cUL

#define SIL_RESERVED_114      22
#define SIL_RESERVED_113      0x400000
#define SIL_RESERVED_112      23
#define SIL_RESERVED_111      0x800000
#define SIL_RESERVED_110      24
#define SIL_RESERVED_109      0x1000000
#define SIL_RESERVED_108      25
#define SIL_RESERVED_107      0x2000000
#define SIL_RESERVED_106      26
#define SIL_RESERVED_105      0x4000000
#define SIL_RESERVED_104      27
#define SIL_RESERVED_103      0x8000000
#define SIL_RESERVED_102      28
#define SIL_RESERVED_101      0x10000000
#define SIL_RESERVED_100      29
#define IOAPIC_GLUE_CG_LCLK_CTRL_0_SOFT_OVERRIDE_CLK2_MASK        0x20000000
#define SIL_RESERVED_99       30
#define SIL_RESERVED_98       0x40000000
#define SIL_RESERVED_97       31
#define SIL_RESERVED_96       0x80000000
#define SIL_RESERVED_731      0x14300100UL

#define SMN_IOHUB0NBIO0_IOAPIC_ID_REGISTER_ADDRESS    0x2801000UL

