; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=loop-vectorize,instsimplify -force-vector-interleave=1 -force-vector-width=2 -S 2>&1 | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

define void @cond_call(ptr readonly %src, ptr noalias %dest, i64 %N) {
; CHECK-LABEL: @cond_call(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N:%.*]], 2
; CHECK-NEXT:    br i1 [[MIN_ITERS_CHECK]], label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; CHECK:       vector.ph:
; CHECK-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 2
; CHECK-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[PRED_CALL_CONTINUE2:%.*]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds i64, ptr [[SRC:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP0]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ult <2 x i64> [[WIDE_LOAD]], <i64 5, i64 5>
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <2 x i1> [[TMP1]], i32 0
; CHECK-NEXT:    br i1 [[TMP2]], label [[PRED_CALL_IF:%.*]], label [[PRED_CALL_CONTINUE:%.*]]
; CHECK:       pred.call.if:
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x i64> [[WIDE_LOAD]], i32 0
; CHECK-NEXT:    [[TMP4:%.*]] = call i64 @foo(i64 [[TMP3]]) #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    [[TMP5:%.*]] = insertelement <2 x i64> poison, i64 [[TMP4]], i32 0
; CHECK-NEXT:    br label [[PRED_CALL_CONTINUE]]
; CHECK:       pred.call.continue:
; CHECK-NEXT:    [[TMP6:%.*]] = phi <2 x i64> [ poison, [[VECTOR_BODY]] ], [ [[TMP5]], [[PRED_CALL_IF]] ]
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <2 x i1> [[TMP1]], i32 1
; CHECK-NEXT:    br i1 [[TMP7]], label [[PRED_CALL_IF1:%.*]], label [[PRED_CALL_CONTINUE2]]
; CHECK:       pred.call.if1:
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[WIDE_LOAD]], i32 1
; CHECK-NEXT:    [[TMP9:%.*]] = call i64 @foo(i64 [[TMP8]]) #[[ATTR0]]
; CHECK-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> [[TMP6]], i64 [[TMP9]], i32 1
; CHECK-NEXT:    br label [[PRED_CALL_CONTINUE2]]
; CHECK:       pred.call.continue2:
; CHECK-NEXT:    [[TMP11:%.*]] = phi <2 x i64> [ [[TMP6]], [[PRED_CALL_CONTINUE]] ], [ [[TMP10]], [[PRED_CALL_IF1]] ]
; CHECK-NEXT:    [[PREDPHI:%.*]] = select <2 x i1> [[TMP1]], <2 x i64> [[TMP11]], <2 x i64> [[WIDE_LOAD]]
; CHECK-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[DEST:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    store <2 x i64> [[PREDPHI]], ptr [[TMP12]], align 8
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; CHECK-NEXT:    [[TMP13:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; CHECK-NEXT:    br i1 [[TMP13]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       middle.block:
; CHECK-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; CHECK-NEXT:    br i1 [[CMP_N]], label [[END:%.*]], label [[SCALAR_PH]]
; CHECK:       scalar.ph:
; CHECK-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[FOR_LOOP:%.*]] ]
; CHECK-NEXT:    [[LD_ADDR:%.*]] = getelementptr inbounds i64, ptr [[SRC]], i64 [[IV]]
; CHECK-NEXT:    [[LD_VALUE:%.*]] = load i64, ptr [[LD_ADDR]], align 8
; CHECK-NEXT:    [[IFCOND:%.*]] = icmp ult i64 [[LD_VALUE]], 5
; CHECK-NEXT:    br i1 [[IFCOND]], label [[IF_THEN:%.*]], label [[FOR_LOOP]]
; CHECK:       if.then:
; CHECK-NEXT:    [[FOO_RET:%.*]] = call i64 @foo(i64 [[LD_VALUE]]) #[[ATTR0]]
; CHECK-NEXT:    br label [[FOR_LOOP]]
; CHECK:       for.loop:
; CHECK-NEXT:    [[ST_VALUE:%.*]] = phi i64 [ [[LD_VALUE]], [[FOR_BODY]] ], [ [[FOO_RET]], [[IF_THEN]] ]
; CHECK-NEXT:    [[ST_ADDR:%.*]] = getelementptr inbounds i64, ptr [[DEST]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[ST_VALUE]], ptr [[ST_ADDR]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[LOOPCOND:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[LOOPCOND]], label [[END]], label [[FOR_BODY]], !llvm.loop [[LOOP2:![0-9]+]]
; CHECK:       end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.body

for.body:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %for.loop ]
  %ld.addr = getelementptr inbounds i64, ptr %src, i64 %iv
  %ld.value = load i64, ptr %ld.addr, align 8
  %ifcond = icmp ult i64 %ld.value, 5
  br i1 %ifcond, label %if.then, label %for.loop

if.then:
  %foo.ret = call i64 @foo(i64 %ld.value) #0
  br label %for.loop

for.loop:
  %st.value = phi i64 [ %ld.value, %for.body ], [ %foo.ret, %if.then ]
  %st.addr = getelementptr inbounds i64, ptr %dest, i64 %iv
  store i64 %st.value, ptr %st.addr, align 8
  %iv.next = add nsw nuw i64 %iv, 1
  %loopcond = icmp eq i64 %iv.next, %N
  br i1 %loopcond, label %end, label %for.body

end:
  ret void
}

declare i64 @foo(i64) #0
declare <4 x i64> @vector_foo(<4 x i64>, <4 x i1>)

; We need a vector variant in order to allow for vectorization at present, but
; we want to test scalarization of conditional calls. If we provide a variant
; with a different number of lanes than the VF we force via
; "-force-vector-width=2", then it should pass the legality checks but
; scalarize. TODO: Remove the requirement to have a variant.
attributes #0 = { readonly nounwind "vector-function-abi-variant"="_ZGV_LLVM_M4v_foo(vector_foo)" }
