# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtDynamicSchemasOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dynamic_schemas_get(self, resource_group):
        response = self.client.dynamic_schemas.get(
            resource_group_name=resource_group.name,
            schema_name="str",
            dynamic_schema_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dynamic_schemas_begin_create_or_update(self, resource_group):
        response = self.client.dynamic_schemas.begin_create_or_update(
            resource_group_name=resource_group.name,
            schema_name="str",
            dynamic_schema_name="str",
            resource={
                "eTag": "str",
                "id": "str",
                "name": "str",
                "properties": {"configurationModel": "str", "configurationType": "str", "provisioningState": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dynamic_schemas_update(self, resource_group):
        response = self.client.dynamic_schemas.update(
            resource_group_name=resource_group.name,
            schema_name="str",
            dynamic_schema_name="str",
            properties={
                "eTag": "str",
                "id": "str",
                "name": "str",
                "properties": {"configurationModel": "str", "configurationType": "str", "provisioningState": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dynamic_schemas_begin_delete(self, resource_group):
        response = self.client.dynamic_schemas.begin_delete(
            resource_group_name=resource_group.name,
            schema_name="str",
            dynamic_schema_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dynamic_schemas_list_by_schema(self, resource_group):
        response = self.client.dynamic_schemas.list_by_schema(
            resource_group_name=resource_group.name,
            schema_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
