/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard.tracker;

import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.apache.felix.http.base.internal.whiteboard.tracker.WhiteboardServiceTracker;
import org.apache.felix.http.jakartawrappers.EventListenerWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class JavaxListenersTracker
extends WhiteboardServiceTracker<EventListener> {
    private static String createListenersFilterExpression() {
        return String.format("(&(|(objectClass=%s)(objectClass=%s)(objectClass=%s)(objectClass=%s)(objectClass=%s)(objectClass=%s)(objectClass=%s))(%s=*)(!(%s~=false)))", HttpSessionAttributeListener.class.getName(), HttpSessionIdListener.class.getName(), HttpSessionListener.class.getName(), javax.servlet.ServletContextListener.class.getName(), javax.servlet.ServletContextAttributeListener.class.getName(), ServletRequestListener.class.getName(), javax.servlet.ServletRequestAttributeListener.class.getName(), "osgi.http.whiteboard.listener", "osgi.http.whiteboard.listener");
    }

    public JavaxListenersTracker(BundleContext context, WhiteboardManager manager) {
        super(manager, context, JavaxListenersTracker.createListenersFilterExpression());
    }

    @Override
    protected WhiteboardServiceInfo<EventListener> getServiceInfo(ServiceReference<EventListener> ref) {
        return new JavaxListenerInfo(ref);
    }

    private static final class JavaxListenerInfo
    extends ListenerInfo {
        public JavaxListenerInfo(ServiceReference<EventListener> ref) {
            super(ref, JavaxListenerInfo.getListenerTypes(ref), JavaxListenerInfo.getDTOListenerTypes(ref));
        }

        @Override
        public EventListener getService(BundleContext bundleContext) {
            EventListener listener = (EventListener)ServiceUtils.safeGetServiceObjects(bundleContext, this.getServiceReference());
            if (listener == null) {
                return null;
            }
            return new EventListenerWrapper(listener, this.getListenerTypes());
        }

        @Override
        public void ungetService(BundleContext bundleContext, EventListener service) {
            if (service instanceof EventListenerWrapper) {
                EventListener listener = ((EventListenerWrapper)service).getListener();
                ServiceUtils.safeUngetServiceObjects(bundleContext, this.getServiceReference(), listener);
            }
        }

        private static String[] getDTOListenerTypes(ServiceReference<EventListener> ref) {
            String[] objectClass;
            HashSet<String> services = new HashSet<String>();
            for (String v : objectClass = (String[])ref.getProperty("objectClass")) {
                if (HttpSessionAttributeListener.class.getName().equals(v)) {
                    services.add(HttpSessionAttributeListener.class.getName());
                    continue;
                }
                if (HttpSessionIdListener.class.getName().equals(v)) {
                    services.add(HttpSessionIdListener.class.getName());
                    continue;
                }
                if (HttpSessionListener.class.getName().equals(v)) {
                    services.add(HttpSessionListener.class.getName());
                    continue;
                }
                if (javax.servlet.ServletContextListener.class.getName().equals(v)) {
                    services.add(javax.servlet.ServletContextListener.class.getName());
                    continue;
                }
                if (javax.servlet.ServletContextAttributeListener.class.getName().equals(v)) {
                    services.add(javax.servlet.ServletContextAttributeListener.class.getName());
                    continue;
                }
                if (ServletRequestListener.class.getName().equals(v)) {
                    services.add(ServletRequestListener.class.getName());
                    continue;
                }
                if (!javax.servlet.ServletRequestAttributeListener.class.getName().equals(v)) continue;
                services.add(javax.servlet.ServletRequestAttributeListener.class.getName());
            }
            return services.toArray(new String[services.size()]);
        }

        private static Set<String> getListenerTypes(ServiceReference<EventListener> ref) {
            String[] objectClass;
            HashSet<String> services = new HashSet<String>();
            for (String v : objectClass = (String[])ref.getProperty("objectClass")) {
                if (HttpSessionAttributeListener.class.getName().equals(v)) {
                    services.add(jakarta.servlet.http.HttpSessionAttributeListener.class.getName());
                    continue;
                }
                if (HttpSessionIdListener.class.getName().equals(v)) {
                    services.add(jakarta.servlet.http.HttpSessionIdListener.class.getName());
                    continue;
                }
                if (HttpSessionListener.class.getName().equals(v)) {
                    services.add(jakarta.servlet.http.HttpSessionListener.class.getName());
                    continue;
                }
                if (javax.servlet.ServletContextListener.class.getName().equals(v)) {
                    services.add(ServletContextListener.class.getName());
                    continue;
                }
                if (javax.servlet.ServletContextAttributeListener.class.getName().equals(v)) {
                    services.add(ServletContextAttributeListener.class.getName());
                    continue;
                }
                if (ServletRequestListener.class.getName().equals(v)) {
                    services.add(jakarta.servlet.ServletRequestListener.class.getName());
                    continue;
                }
                if (!javax.servlet.ServletRequestAttributeListener.class.getName().equals(v)) continue;
                services.add(ServletRequestAttributeListener.class.getName());
            }
            return services;
        }
    }
}

