; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+m,+f,+d,+a,+c,+v \
; RUN:   -target-abi=lp64d -verify-machineinstrs -O0 < %s | FileCheck %s

declare i64 @llvm.riscv.vsetvli(i64, i64, i64)
declare i64 @llvm.riscv.vsetvlimax(i64, i64)
declare <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
  <vscale x 1 x double>,
  <vscale x 1 x double>,
  <vscale x 1 x double>,
  i64, i64)
declare <vscale x 1 x i64> @llvm.riscv.vle.mask.nxv1i64(
  <vscale x 1 x i64>,
  ptr,
  <vscale x 1 x i1>,
  i64, i64)

define <2 x double> @fixed_length(<2 x double> %a, <2 x double> %b) nounwind {
; CHECK-LABEL: fixed_length:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    # kill: def $v11 killed $v10
; CHECK-NEXT:    # kill: def $v9 killed $v8
; CHECK-NEXT:    # implicit-def: $v9
; CHECK-NEXT:    vfadd.vv v9, v8, v10
; CHECK-NEXT:    # implicit-def: $v8
; CHECK-NEXT:    vfadd.vv v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %1 = fadd <2 x double> %a, %b
  %2 = fadd <2 x double> %1, %b
  ret <2 x double> %2
}

define <vscale x 1 x double> @scalable(<vscale x 1 x double> %a, <vscale x 1 x double> %b) nounwind {
; CHECK-LABEL: scalable:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    # implicit-def: $v9
; CHECK-NEXT:    vfadd.vv v9, v8, v10
; CHECK-NEXT:    # implicit-def: $v8
; CHECK-NEXT:    vfadd.vv v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %1 = fadd <vscale x 1 x double> %a, %b
  %2 = fadd <vscale x 1 x double> %1, %b
  ret <vscale x 1 x double> %2
}


define <vscale x 1 x double> @intrinsic_same_vlmax(<vscale x 1 x double> %a, <vscale x 1 x double> %b) nounwind {
; CHECK-LABEL: intrinsic_same_vlmax:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    # implicit-def: $v9
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v9, v8, v10
; CHECK-NEXT:    # implicit-def: $v8
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call i64 @llvm.riscv.vsetvlimax(i64 2, i64 7)
  %1 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %a,
    <vscale x 1 x double> %b,
    i64 7, i64 %0)
  %2 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %1,
    <vscale x 1 x double> %b,
    i64 7, i64 %0)
  ret <vscale x 1 x double> %2
}


define <vscale x 1 x double> @intrinsic_same_avl_imm(<vscale x 1 x double> %a, <vscale x 1 x double> %b) nounwind {
; CHECK-LABEL: intrinsic_same_avl_imm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli a0, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    # implicit-def: $v9
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v9, v8, v10
; CHECK-NEXT:    # implicit-def: $v8
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call i64 @llvm.riscv.vsetvli(i64 2, i64 2, i64 7)
  %1 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %a,
    <vscale x 1 x double> %b,
    i64 7, i64 %0)
  %2 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %1,
    <vscale x 1 x double> %b,
    i64 7, i64 %0)
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @intrinsic_same_avl_reg(i64 %avl, <vscale x 1 x double> %a, <vscale x 1 x double> %b) nounwind {
; CHECK-LABEL: intrinsic_same_avl_reg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 1, e8, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vsetvli a0, a0, e32, mf2, ta, ma
; CHECK-NEXT:    # implicit-def: $v9
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v9, v8, v10
; CHECK-NEXT:    # implicit-def: $v8
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call i64 @llvm.riscv.vsetvli(i64 %avl, i64 2, i64 7)
  %1 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %a,
    <vscale x 1 x double> %b,
    i64 7, i64 %0)
  %2 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %1,
    <vscale x 1 x double> %b,
    i64 7, i64 %0)
  ret <vscale x 1 x double> %2
}

define <vscale x 1 x double> @intrinsic_diff_avl_reg(i64 %avl, i64 %avl2, <vscale x 1 x double> %a, <vscale x 1 x double> %b) nounwind {
; CHECK-LABEL: intrinsic_diff_avl_reg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 1, e8, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v9
; CHECK-NEXT:    vsetvli a0, a0, e32, mf2, ta, ma
; CHECK-NEXT:    # implicit-def: $v9
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v9, v8, v10
; CHECK-NEXT:    vsetvli a0, a1, e32, mf2, ta, ma
; CHECK-NEXT:    # implicit-def: $v8
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, tu, ma
; CHECK-NEXT:    vfadd.vv v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call i64 @llvm.riscv.vsetvli(i64 %avl, i64 2, i64 7)
  %1 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %a,
    <vscale x 1 x double> %b,
    i64 7, i64 %0)
  %2 = tail call i64 @llvm.riscv.vsetvli(i64 %avl2, i64 2, i64 7)
  %3 = tail call <vscale x 1 x double> @llvm.riscv.vfadd.nxv1f64.nxv1f64(
    <vscale x 1 x double> undef,
    <vscale x 1 x double> %1,
    <vscale x 1 x double> %b,
    i64 7, i64 %2)
  ret <vscale x 1 x double> %3
}
