% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_draws_matrix.R
\name{draws_matrix}
\alias{draws_matrix}
\alias{as_draws_matrix}
\alias{as_draws_matrix.default}
\alias{as_draws_matrix.draws_matrix}
\alias{as_draws_matrix.draws_array}
\alias{as_draws_matrix.draws_df}
\alias{as_draws_matrix.draws_list}
\alias{as_draws_matrix.draws_rvars}
\alias{as_draws_matrix.mcmc}
\alias{as_draws_matrix.mcmc.list}
\alias{is_draws_matrix}
\title{The \code{draws_matrix} format}
\usage{
as_draws_matrix(x, ...)

\method{as_draws_matrix}{default}(x, ...)

\method{as_draws_matrix}{draws_matrix}(x, ...)

\method{as_draws_matrix}{draws_array}(x, ...)

\method{as_draws_matrix}{draws_df}(x, ...)

\method{as_draws_matrix}{draws_list}(x, ...)

\method{as_draws_matrix}{draws_rvars}(x, ...)

\method{as_draws_matrix}{mcmc}(x, ...)

\method{as_draws_matrix}{mcmc.list}(x, ...)

draws_matrix(..., .nchains = 1)

is_draws_matrix(x)
}
\arguments{
\item{x}{An object to convert to a \code{draws_matrix} object.}

\item{...}{For \code{as_draws_matrix()}:
Arguments passed to individual methods (if applicable).
For \code{draws_matrix()}: Named
arguments containing numeric vectors each defining a separate variable.}

\item{.nchains}{(positive integer) The number of chains. The default is \code{1}.}
}
\value{
A \code{draws_matrix} object, which has classes
\code{c("draws_matrix", "draws", "matrix")}.
}
\description{
The \code{as_draws_matrix()} methods convert
objects to the \code{draws_matrix} format.
The \code{draws_matrix()} function creates an object of the
\code{draws_matrix} format based on a set of numeric vectors.
See \strong{Details}.
}
\details{
Objects of class \code{"draws_matrix"} are matrices (2-D arrays) with
dimensions \code{"draw"} and \code{"variable"}. See \strong{Examples}.
}
\examples{
x1 <- as_draws_matrix(example_draws())
class(x1)
print(x1)
str(x1)

x2 <- draws_matrix(a = rnorm(10), b = rnorm(10), c = 1)
class(x2)
print(x2)
str(x2)
}
\seealso{
Other formats: 
\code{\link{draws}},
\code{\link{draws_array}()},
\code{\link{draws_df}()},
\code{\link{draws_list}()},
\code{\link{draws_rvars}()}
}
\concept{formats}
