---@meta
error('Cannot require a meta file')

---@class InstallInfo
---
---URL of parser repo (Github)
---@field url string
---
---Commit hash of parser to download (compatible with queries)
---@field revision string
---
---Branch of parser repo to download (if not default branch)
---@field branch? string
---
---Location of `grammar.js` in repo (if not at root, e.g., in a monorepo)
---@field location? string
---
---Repo does not contain a `parser.c`; must be generated from grammar first
---@field generate? boolean
---
---Generate parser from `grammar.json` instead of `grammar.js` (default true)
---@field generate_from_json? boolean
---
---Parser repo is a local directory; overrides `url`, `revision`, and `branch`
---@field path? string
---
---Directory with queries to be installed
---@field queries? string

---@class ParserInfo
---
---Information necessary to build and install the parser (empty for query-only language)
---@field install_info? InstallInfo
---
---List of Github users maintaining the queries for Neovim
---@field maintainers? string[]
---
---List of other languages to install (e.g., if queries inherit from them)
---@field requires? string[]
---
---Language support tier, maps to "stable", "unstable", "unmaintained", "unsupported"
---@field tier integer
---
---Explanatory footnote text to add in SUPPORTED_LANGUAGES.md
---@field readme_note? string

---@alias nvim-ts.parsers table<string,ParserInfo>
