% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom-dbscan-tidiers.R
\name{dbscan_tidiers}
\alias{dbscan_tidiers}
\alias{glance}
\alias{tidy}
\alias{augment}
\alias{tidy.dbscan}
\alias{tidy.hdbscan}
\alias{tidy.general_clustering}
\alias{augment.dbscan}
\alias{augment.hdbscan}
\alias{augment.general_clustering}
\alias{glance.dbscan}
\alias{glance.hdbscan}
\alias{glance.general_clustering}
\title{Turn an dbscan clustering object into a tidy tibble}
\usage{
tidy(x, ...)

\method{tidy}{dbscan}(x, ...)

\method{tidy}{hdbscan}(x, ...)

\method{tidy}{general_clustering}(x, ...)

augment(x, ...)

\method{augment}{dbscan}(x, data = NULL, newdata = NULL, ...)

\method{augment}{hdbscan}(x, data = NULL, newdata = NULL, ...)

\method{augment}{general_clustering}(x, data = NULL, newdata = NULL, ...)

glance(x, ...)

\method{glance}{dbscan}(x, ...)

\method{glance}{hdbscan}(x, ...)

\method{glance}{general_clustering}(x, ...)
}
\arguments{
\item{x}{An \code{dbscan} object returned from \code{\link[=dbscan]{dbscan()}}.}

\item{...}{further arguments are ignored without a warning.}

\item{data}{The data used to create the clustering.}

\item{newdata}{New data to predict cluster labels for.}
}
\description{
Provides \link[generics:tidy]{tidy()}, \link[generics:augment]{augment()}, and
\link[generics:glance]{glance()} verbs for clusterings created with algorithms
in package \code{dbscan} to work with \href{https://www.tidymodels.org/}{tidymodels}.
}
\examples{
\dontshow{if (requireNamespace("tibble", quietly = TRUE) && identical(Sys.getenv("NOT_CRAN"), "true")) withAutoprint(\{ # examplesIf}

data(iris)
x <- scale(iris[, 1:4])

## dbscan
db <- dbscan(x, eps = .9, minPts = 5)
db

# summarize model fit with tidiers
tidy(db)
glance(db)

# augment for this model needs the original data
augment(db, x)

# to augment new data, the original data is also needed
augment(db, x, newdata = x[1:5, ])

## hdbscan
hdb <- hdbscan(x, minPts = 5)

# summarize model fit with tidiers
tidy(hdb)
glance(hdb)

# augment for this model needs the original data
augment(hdb, x)

# to augment new data, the original data is also needed
augment(hdb, x, newdata = x[1:5, ])

## Jarvis-Patrick clustering
cl <- jpclust(x, k = 20, kt = 15)

# summarize model fit with tidiers
tidy(cl)
glance(cl)

# augment for this model needs the original data
augment(cl, x)

## Shared Nearest Neighbor clustering
cl <- sNNclust(x, k = 20, eps = 0.8, minPts = 15)

# summarize model fit with tidiers
tidy(cl)
glance(cl)

# augment for this model needs the original data
augment(cl, x)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[generics:tidy]{generics::tidy()}}, \code{\link[generics:augment]{generics::augment()}},
\code{\link[generics:glance]{generics::glance()}}, \code{\link[=dbscan]{dbscan()}}
}
\concept{tidiers}
