// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Align, Application, Bin, Buildable, Container, Dialog, License, ResizeMode, Widget, Window,
    WindowPosition, WindowType,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkAboutDialog")]
    pub struct AboutDialog(Object<ffi::GtkAboutDialog, ffi::GtkAboutDialogClass>) @extends Dialog, Window, Bin, Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_about_dialog_get_type(),
    }
}

impl AboutDialog {
    pub const NONE: Option<&'static AboutDialog> = None;

    #[doc(alias = "gtk_about_dialog_new")]
    pub fn new() -> AboutDialog {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_about_dialog_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`AboutDialog`] objects.
    ///
    /// This method returns an instance of [`AboutDialogBuilder`](crate::builders::AboutDialogBuilder) which can be used to create [`AboutDialog`] objects.
    pub fn builder() -> AboutDialogBuilder {
        AboutDialogBuilder::new()
    }
}

impl Default for AboutDialog {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`AboutDialog`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AboutDialogBuilder {
    builder: glib::object::ObjectBuilder<'static, AboutDialog>,
}

impl AboutDialogBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn artists(self, artists: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("artists", artists.into()),
        }
    }

    pub fn authors(self, authors: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("authors", authors.into()),
        }
    }

    pub fn comments(self, comments: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("comments", comments.into()),
        }
    }

    pub fn copyright(self, copyright: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("copyright", copyright.into()),
        }
    }

    pub fn documenters(self, documenters: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("documenters", documenters.into()),
        }
    }

    pub fn license(self, license: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("license", license.into()),
        }
    }

    pub fn license_type(self, license_type: License) -> Self {
        Self {
            builder: self.builder.property("license-type", license_type),
        }
    }

    pub fn logo(self, logo: &gdk_pixbuf::Pixbuf) -> Self {
        Self {
            builder: self.builder.property("logo", logo.clone()),
        }
    }

    pub fn logo_icon_name(self, logo_icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("logo-icon-name", logo_icon_name.into()),
        }
    }

    pub fn program_name(self, program_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("program-name", program_name.into()),
        }
    }

    pub fn translator_credits(self, translator_credits: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("translator-credits", translator_credits.into()),
        }
    }

    pub fn version(self, version: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("version", version.into()),
        }
    }

    pub fn website(self, website: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("website", website.into()),
        }
    }

    pub fn website_label(self, website_label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("website-label", website_label.into()),
        }
    }

    pub fn wrap_license(self, wrap_license: bool) -> Self {
        Self {
            builder: self.builder.property("wrap-license", wrap_license),
        }
    }

    pub fn use_header_bar(self, use_header_bar: i32) -> Self {
        Self {
            builder: self.builder.property("use-header-bar", use_header_bar),
        }
    }

    pub fn accept_focus(self, accept_focus: bool) -> Self {
        Self {
            builder: self.builder.property("accept-focus", accept_focus),
        }
    }

    pub fn application(self, application: &impl IsA<Application>) -> Self {
        Self {
            builder: self
                .builder
                .property("application", application.clone().upcast()),
        }
    }

    pub fn attached_to(self, attached_to: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("attached-to", attached_to.clone().upcast()),
        }
    }

    pub fn decorated(self, decorated: bool) -> Self {
        Self {
            builder: self.builder.property("decorated", decorated),
        }
    }

    pub fn default_height(self, default_height: i32) -> Self {
        Self {
            builder: self.builder.property("default-height", default_height),
        }
    }

    pub fn default_width(self, default_width: i32) -> Self {
        Self {
            builder: self.builder.property("default-width", default_width),
        }
    }

    pub fn deletable(self, deletable: bool) -> Self {
        Self {
            builder: self.builder.property("deletable", deletable),
        }
    }

    pub fn destroy_with_parent(self, destroy_with_parent: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("destroy-with-parent", destroy_with_parent),
        }
    }

    pub fn focus_on_map(self, focus_on_map: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-map", focus_on_map),
        }
    }

    pub fn focus_visible(self, focus_visible: bool) -> Self {
        Self {
            builder: self.builder.property("focus-visible", focus_visible),
        }
    }

    pub fn gravity(self, gravity: gdk::Gravity) -> Self {
        Self {
            builder: self.builder.property("gravity", gravity),
        }
    }

    pub fn hide_titlebar_when_maximized(self, hide_titlebar_when_maximized: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("hide-titlebar-when-maximized", hide_titlebar_when_maximized),
        }
    }

    pub fn icon(self, icon: &gdk_pixbuf::Pixbuf) -> Self {
        Self {
            builder: self.builder.property("icon", icon.clone()),
        }
    }

    pub fn icon_name(self, icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("icon-name", icon_name.into()),
        }
    }

    pub fn mnemonics_visible(self, mnemonics_visible: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonics-visible", mnemonics_visible),
        }
    }

    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    pub fn resizable(self, resizable: bool) -> Self {
        Self {
            builder: self.builder.property("resizable", resizable),
        }
    }

    pub fn role(self, role: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("role", role.into()),
        }
    }

    pub fn screen(self, screen: &gdk::Screen) -> Self {
        Self {
            builder: self.builder.property("screen", screen.clone()),
        }
    }

    pub fn skip_pager_hint(self, skip_pager_hint: bool) -> Self {
        Self {
            builder: self.builder.property("skip-pager-hint", skip_pager_hint),
        }
    }

    pub fn skip_taskbar_hint(self, skip_taskbar_hint: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("skip-taskbar-hint", skip_taskbar_hint),
        }
    }

    pub fn startup_id(self, startup_id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("startup-id", startup_id.into()),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn transient_for(self, transient_for: &impl IsA<Window>) -> Self {
        Self {
            builder: self
                .builder
                .property("transient-for", transient_for.clone().upcast()),
        }
    }

    pub fn type_(self, type_: WindowType) -> Self {
        Self {
            builder: self.builder.property("type", type_),
        }
    }

    pub fn type_hint(self, type_hint: gdk::WindowTypeHint) -> Self {
        Self {
            builder: self.builder.property("type-hint", type_hint),
        }
    }

    pub fn urgency_hint(self, urgency_hint: bool) -> Self {
        Self {
            builder: self.builder.property("urgency-hint", urgency_hint),
        }
    }

    pub fn window_position(self, window_position: WindowPosition) -> Self {
        Self {
            builder: self.builder.property("window-position", window_position),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`AboutDialog`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> AboutDialog {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::AboutDialog>> Sealed for T {}
}

pub trait AboutDialogExt: IsA<AboutDialog> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_about_dialog_add_credit_section")]
    fn add_credit_section(&self, section_name: &str, people: &[&str]) {
        unsafe {
            ffi::gtk_about_dialog_add_credit_section(
                self.as_ref().to_glib_none().0,
                section_name.to_glib_none().0,
                people.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_get_artists")]
    #[doc(alias = "get_artists")]
    fn artists(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_about_dialog_get_artists(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_authors")]
    #[doc(alias = "get_authors")]
    fn authors(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_about_dialog_get_authors(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_comments")]
    #[doc(alias = "get_comments")]
    fn comments(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_comments(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_copyright")]
    #[doc(alias = "get_copyright")]
    fn copyright(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_copyright(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_documenters")]
    #[doc(alias = "get_documenters")]
    fn documenters(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_about_dialog_get_documenters(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_license")]
    #[doc(alias = "get_license")]
    fn license(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_license(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_license_type")]
    #[doc(alias = "get_license_type")]
    fn license_type(&self) -> License {
        unsafe {
            from_glib(ffi::gtk_about_dialog_get_license_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_logo")]
    #[doc(alias = "get_logo")]
    fn logo(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_logo(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_logo_icon_name")]
    #[doc(alias = "get_logo_icon_name")]
    fn logo_icon_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_logo_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_program_name")]
    #[doc(alias = "get_program_name")]
    fn program_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_program_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_translator_credits")]
    #[doc(alias = "get_translator_credits")]
    fn translator_credits(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_translator_credits(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_version")]
    #[doc(alias = "get_version")]
    fn version(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_version(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_website")]
    #[doc(alias = "get_website")]
    fn website(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_website(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_website_label")]
    #[doc(alias = "get_website_label")]
    fn website_label(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_about_dialog_get_website_label(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_get_wrap_license")]
    #[doc(alias = "get_wrap_license")]
    fn wraps_license(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_about_dialog_get_wrap_license(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_about_dialog_set_artists")]
    fn set_artists(&self, artists: &[&str]) {
        unsafe {
            ffi::gtk_about_dialog_set_artists(
                self.as_ref().to_glib_none().0,
                artists.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_authors")]
    fn set_authors(&self, authors: &[&str]) {
        unsafe {
            ffi::gtk_about_dialog_set_authors(
                self.as_ref().to_glib_none().0,
                authors.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_comments")]
    fn set_comments(&self, comments: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_comments(
                self.as_ref().to_glib_none().0,
                comments.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_copyright")]
    fn set_copyright(&self, copyright: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_copyright(
                self.as_ref().to_glib_none().0,
                copyright.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_documenters")]
    fn set_documenters(&self, documenters: &[&str]) {
        unsafe {
            ffi::gtk_about_dialog_set_documenters(
                self.as_ref().to_glib_none().0,
                documenters.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_license")]
    fn set_license(&self, license: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_license(
                self.as_ref().to_glib_none().0,
                license.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_license_type")]
    fn set_license_type(&self, license_type: License) {
        unsafe {
            ffi::gtk_about_dialog_set_license_type(
                self.as_ref().to_glib_none().0,
                license_type.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_logo")]
    fn set_logo(&self, logo: Option<&gdk_pixbuf::Pixbuf>) {
        unsafe {
            ffi::gtk_about_dialog_set_logo(self.as_ref().to_glib_none().0, logo.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_about_dialog_set_logo_icon_name")]
    fn set_logo_icon_name(&self, icon_name: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_logo_icon_name(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_program_name")]
    fn set_program_name(&self, name: &str) {
        unsafe {
            ffi::gtk_about_dialog_set_program_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_translator_credits")]
    fn set_translator_credits(&self, translator_credits: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_translator_credits(
                self.as_ref().to_glib_none().0,
                translator_credits.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_version")]
    fn set_version(&self, version: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_version(
                self.as_ref().to_glib_none().0,
                version.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_website")]
    fn set_website(&self, website: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_website(
                self.as_ref().to_glib_none().0,
                website.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_website_label")]
    fn set_website_label(&self, website_label: Option<&str>) {
        unsafe {
            ffi::gtk_about_dialog_set_website_label(
                self.as_ref().to_glib_none().0,
                website_label.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_about_dialog_set_wrap_license")]
    fn set_wrap_license(&self, wrap_license: bool) {
        unsafe {
            ffi::gtk_about_dialog_set_wrap_license(
                self.as_ref().to_glib_none().0,
                wrap_license.into_glib(),
            );
        }
    }

    #[doc(alias = "activate-link")]
    fn connect_activate_link<F: Fn(&Self, &str) -> glib::Propagation + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_link_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P, &str) -> glib::Propagation + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            uri: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                AboutDialog::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(uri),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-link\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_link_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "artists")]
    fn connect_artists_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_artists_trampoline<P: IsA<AboutDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::artists\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_artists_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "authors")]
    fn connect_authors_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_authors_trampoline<P: IsA<AboutDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::authors\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_authors_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "comments")]
    fn connect_comments_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_comments_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::comments\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_comments_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "copyright")]
    fn connect_copyright_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_copyright_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::copyright\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_copyright_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "documenters")]
    fn connect_documenters_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_documenters_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::documenters\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_documenters_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "license")]
    fn connect_license_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_trampoline<P: IsA<AboutDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::license\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_license_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "license-type")]
    fn connect_license_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_type_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::license-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_license_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "logo")]
    fn connect_logo_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_logo_trampoline<P: IsA<AboutDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::logo\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_logo_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "logo-icon-name")]
    fn connect_logo_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_logo_icon_name_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::logo-icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_logo_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "program-name")]
    fn connect_program_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_program_name_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::program-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_program_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "translator-credits")]
    fn connect_translator_credits_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_translator_credits_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::translator-credits\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_translator_credits_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "version")]
    fn connect_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_version_trampoline<P: IsA<AboutDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::version\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_version_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "website")]
    fn connect_website_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_website_trampoline<P: IsA<AboutDialog>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::website\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_website_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "website-label")]
    fn connect_website_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_website_label_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::website-label\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_website_label_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrap-license")]
    fn connect_wrap_license_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_license_trampoline<
            P: IsA<AboutDialog>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AboutDialog::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-license\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_license_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<AboutDialog>> AboutDialogExt for O {}

impl fmt::Display for AboutDialog {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("AboutDialog")
    }
}
