// Take a look at the license at the top of the repository in the LICENSE file.

// rustdoc-stripper-ignore-next
//! Traits intended for subclassing [`CheckButton`].

use glib::translate::*;

use crate::{Actionable, CheckButton, ffi, prelude::*, subclass::prelude::*};

pub trait CheckButtonImpl:
    WidgetImpl + ObjectSubclass<Type: IsA<CheckButton> + IsA<Actionable>>
{
    fn toggled(&self) {
        self.parent_toggled()
    }

    #[cfg(feature = "v4_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
    fn activate(&self) {
        self.parent_activate()
    }
}

pub trait CheckButtonImplExt: CheckButtonImpl {
    fn parent_toggled(&self) {
        unsafe {
            let data = Self::type_data();
            let parent_class = data.as_ref().parent_class() as *mut ffi::GtkCheckButtonClass;
            if let Some(f) = (*parent_class).toggled {
                f(self.obj().unsafe_cast_ref::<CheckButton>().to_glib_none().0)
            }
        }
    }

    #[cfg(feature = "v4_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
    fn parent_activate(&self) {
        unsafe {
            let data = Self::type_data();
            let parent_class = data.as_ref().parent_class() as *mut ffi::GtkCheckButtonClass;
            if let Some(f) = (*parent_class).activate {
                f(self.obj().unsafe_cast_ref::<CheckButton>().to_glib_none().0)
            }
        }
    }
}

impl<T: CheckButtonImpl> CheckButtonImplExt for T {}

unsafe impl<T: CheckButtonImpl> IsSubclassable<T> for CheckButton {
    fn class_init(class: &mut glib::Class<Self>) {
        Self::parent_class_init::<T>(class);

        let klass = class.as_mut();
        klass.toggled = Some(check_button_toggled::<T>);

        #[cfg(feature = "v4_2")]
        #[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
        {
            klass.activate = Some(check_button_activate::<T>);
        };
    }
}

unsafe extern "C" fn check_button_toggled<T: CheckButtonImpl>(ptr: *mut ffi::GtkCheckButton) {
    unsafe {
        let instance = &*(ptr as *mut T::Instance);
        let imp = instance.imp();

        imp.toggled()
    }
}

#[cfg(feature = "v4_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_2")))]
unsafe extern "C" fn check_button_activate<T: CheckButtonImpl>(ptr: *mut ffi::GtkCheckButton) {
    unsafe {
        let instance = &*(ptr as *mut T::Instance);
        let imp = instance.imp();

        imp.activate()
    }
}
