# Native library for Chromium SWT

## Build native library and subprocess executable

### Prerequisites

- Rust (https://www.rust-lang.org/en-US/install.html)

- Download CEF binary distrubution (minimal is enough for release builds), unzip it and rename to ./chromium_subp/cef_[os]/ (Where [os]=linux|macosx|win32)

### Build

#### Build subprocess helper executable

- cd chromium_subp
- `cargo build --release`
- `strip target/release/chromium_subp` (linux only)
- `strip -r -u target/release/chromium_subp` (macos only)
- `install_name_tool -change "@rpath/Frameworks/Chromium Embedded Framework.framework/Chromium Embedded Framework" "@loader_path/../../../Chromium Embedded Framework.framework/Chromium Embedded Framework" target/release/chromium_subp` (macos only)

#### Build native library

- cd chromium_swt
- `cargo build --release`
- `strip target/release/libchromium_swt.so` (linux only)
- `strip -r -u target/release/libchromium_swt.dylib` (macos only)
- `install_name_tool -change "@rpath/Frameworks/Chromium Embedded Framework.framework/Chromium Embedded Framework" "@loader_path/Chromium Embedded Framework.framework/Chromium Embedded Framework" target/release/libchromium_swt.dylib` (macos only)

Copy library and binary from target/release/ to corresponding eclipse fragment

### Bindings

CEF bindings for Rust are autogenerated. Types to generate are configured on build.rs (whitelisted and blacklisted types) 
and cef_*.h header files in chromium_subp/ folder.
This uses https://rust-lang.github.io/rust-bindgen/introduction.html. See there for specific details about configuration options and how to tune the generation.

#### Generate Rust CEF Bindings

- cd chromium_subp
- `cargo build --features gen --release`
