/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.style;

import java.util.List;
import org.apache.sling.xss.impl.style.BatikCssCleaner;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;

class StyleTagProcessor
implements HtmlStreamEventProcessor {
    private final BatikCssCleaner cssCleaner;

    StyleTagProcessor(BatikCssCleaner cssCleaner) {
        this.cssCleaner = cssCleaner;
    }

    @Override
    public HtmlStreamEventReceiver wrap(HtmlStreamEventReceiver sink) {
        return new StyleTagReceiver(sink);
    }

    class StyleTagReceiver
    implements HtmlStreamEventReceiver {
        private final HtmlStreamEventReceiver wrapped;
        private boolean inStyleTag;

        StyleTagReceiver(HtmlStreamEventReceiver wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void openDocument() {
            this.wrapped.openDocument();
        }

        @Override
        public void closeDocument() {
            this.wrapped.closeDocument();
        }

        @Override
        public void openTag(String elementName, List<String> attrs) {
            this.wrapped.openTag(elementName, attrs);
            this.inStyleTag = "style".equals(elementName);
        }

        @Override
        public void closeTag(String elementName) {
            this.wrapped.closeTag(elementName);
            this.inStyleTag = false;
        }

        @Override
        public void text(String taintedCss) {
            if (this.inStyleTag) {
                this.wrapped.text(StyleTagProcessor.this.cssCleaner.cleanStylesheet(taintedCss));
            } else {
                this.wrapped.text(taintedCss);
            }
        }
    }
}

