/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.script.Bindings;
import org.apache.commons.lang3.Strings;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

class MockSlingBindings
extends SlingBindings
implements EventHandler {
    private static final long serialVersionUID = 1L;
    private static final String PROP_CURRENT_NODE = "currentNode";
    private static final String PROP_CURRENT_SESSION = "currentSession";
    static final String SERVICE_PROPERTY_MOCK_SLING_BINDINGS_IGNORE = "MockSlingBindings-ignore";
    private volatile SlingContextImpl context;

    public MockSlingBindings(SlingContextImpl context) {
        this.context = context;
        this.populateFromBindingsValuesProvider();
    }

    public Object get(Object key) {
        String keyString;
        Object result;
        if (this.context == null) {
            return null;
        }
        if (key instanceof String && (result = this.context.resolveSlingBindingProperty(keyString = (String)key, (SlingJakartaHttpServletRequest)this.context.jakartaRequest())) != null) {
            return result;
        }
        return super.get(key);
    }

    private void populateFromBindingsValuesProvider() {
        LazyBindings bindings = new LazyBindings();
        for (BindingsValuesProvider provider : (BindingsValuesProvider[])this.context.getServices(BindingsValuesProvider.class, "(!(MockSlingBindings-ignore=true))")) {
            provider.addBindings((Bindings)bindings);
        }
        this.clear();
        this.putAll((Map)bindings);
    }

    public void handleEvent(Event event) {
        if (this.context == null) {
            return;
        }
        this.populateFromBindingsValuesProvider();
    }

    @Nullable
    static Object resolveSlingBindingProperty(@NotNull SlingContextImpl context, @NotNull String property) {
        Resource resource;
        if (Strings.CS.equals(property, "resolver")) {
            return context.resourceResolver();
        }
        if (Strings.CS.equals(property, "resource")) {
            return context.currentResource();
        }
        if (Strings.CS.equals(property, "request")) {
            return context.request();
        }
        if (Strings.CS.equals(property, "response")) {
            return context.response();
        }
        if (Strings.CS.equals(property, "jakartaRequest")) {
            return context.jakartaRequest();
        }
        if (Strings.CS.equals(property, "jakartaResponse")) {
            return context.jakartaResponse();
        }
        if (Strings.CS.equals(property, "sling")) {
            return context.slingScriptHelper();
        }
        if (Strings.CS.equals(property, "reader")) {
            return context.jakartaRequest().getReader();
        }
        if (Strings.CS.equals(property, "out")) {
            return context.jakartaResponse().getWriter();
        }
        if (Strings.CS.equals(property, PROP_CURRENT_NODE) && (resource = context.currentResource()) != null) {
            return resource.adaptTo(Node.class);
        }
        if (Strings.CS.equals(property, PROP_CURRENT_SESSION)) {
            return context.resourceResolver().adaptTo(Session.class);
        }
        return null;
    }

    public void tearDown() {
        this.context = null;
    }
}

