; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx600 < %s | FileCheck -check-prefixes=GFX6,GFX6-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx803 < %s | FileCheck -check-prefixes=GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX950,GFX9-SDAG,GFX900-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx950 < %s | FileCheck -check-prefixes=GFX9,GFX950,GFX9-SDAG,GFX950-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-FAKE16 %s

; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx600 < %s | FileCheck -check-prefixes=GFX6,GFX6-GISEL %s
; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-GISEL %s
; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx803 < %s | FileCheck -check-prefixes=GFX8,GFX8-GISEL %s
; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX950,GFX9-GISEL,GFX900-GISEL %s
; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx950 < %s | FileCheck -check-prefixes=GFX9,GFX950,GFX9-GISEL,GFX950-GISEL %s
; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s
; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL %s
; xUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL %s

define float @v_max3_f32_maximumnum_maximumnum__v_v_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_v_v_1(float %a, float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v2, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v2, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v2, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v2, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v2, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v2, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v2, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %c, float %tmp0)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__i_v_v_0(float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, 1.0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float 1.0, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__i_v_v_1(float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__i_v_v_1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v1, v0, 1.0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float 1.0, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %c, float %tmp0)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_i_v_0(float %a, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, 1.0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, 1.0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float 1.0)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_i_v_1(float %a, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v1, v0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_i_v_1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v1, v0, 1.0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float 1.0)
  %max3 = call float @llvm.maximumnum.f32(float %c, float %tmp0)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_v_i(float %a, float %b) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_i:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, 1.0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_i:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, 1.0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_i:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, v1, 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_i:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, v1, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_i:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v1, 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_i:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_i:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v1, 1.0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float 1.0)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_k_v(float %a, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x41000000
; GFX6-NEXT:    v_max3_f32 v0, v0, s4, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s4, 0x41000000
; GFX7-NEXT:    v_max3_f32 v0, v0, s4, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s4, 0x41000000
; GFX8-NEXT:    v_max3_f32 v0, v0, s4, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    s_mov_b32 s4, 0x41000000
; GFX900-SDAG-NEXT:    v_max3_f32 v0, v0, s4, v1
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s0, 0x41000000
; GFX950-SDAG-NEXT:    v_max3_f32 v0, v0, s0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, 0x41000000, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, 0x41000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_k_v:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, 0x41000000, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float 8.0)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_v_k(float %a, float %b) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, 0x41000000
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, s4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s4, 0x41000000
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, s4
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s4, 0x41000000
; GFX8-NEXT:    v_max3_f32 v0, v0, v1, s4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    s_mov_b32 s4, 0x41000000
; GFX900-SDAG-NEXT:    v_max3_f32 v0, v0, v1, s4
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s0, 0x41000000
; GFX950-SDAG-NEXT:    v_max3_f32 v0, v0, v1, s0
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v1, 0x41000000
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, 0x41000000
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_k:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v1, 0x41000000
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float 8.0)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__s_v_v(float inreg %a, float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_v:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, s0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__s_s_v(float inreg %a, float inreg %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s17
; GFX6-NEXT:    v_max3_f32 v0, s16, v1, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s17
; GFX7-NEXT:    v_max3_f32 v0, s16, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NEXT:    v_max3_f32 v0, s16, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_mov_b32_e32 v1, s17
; GFX900-SDAG-NEXT:    v_max3_f32 v0, s16, v1, v0
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX950-SDAG-NEXT:    v_max3_f32 v0, s0, v1, v0
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, s16, s17, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, s0, s1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_v:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, s0, s1, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__s_v_s(float inreg %a, float %b, float inreg %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s17
; GFX6-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s17
; GFX7-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s17
; GFX8-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_mov_b32_e32 v1, s17
; GFX900-SDAG-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX950-SDAG-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, s16, v0, s17
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, s0, v0, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__s_v_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, s0, v0, s1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__s_s_s(float inreg %a, float inreg %b, float inreg %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, s17
; GFX6-NEXT:    v_mov_b32_e32 v1, s18
; GFX6-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s17
; GFX7-NEXT:    v_mov_b32_e32 v1, s18
; GFX7-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s17
; GFX8-NEXT:    v_mov_b32_e32 v1, s18
; GFX8-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_mov_b32_e32 v0, s17
; GFX900-SDAG-NEXT:    v_mov_b32_e32 v1, s18
; GFX900-SDAG-NEXT:    v_max3_f32 v0, s16, v0, v1
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v0, s1
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX950-SDAG-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s18
; GFX10-NEXT:    v_max3_f32 v0, s16, s17, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max3_f32 v0, s0, s1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max3_num_f32 v0, s0, s1, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define amdgpu_ps i32 @s_max3_f32_maximumnum_maximumnum__s_s_s(float inreg %a, float inreg %b, float inreg %c) {
; GFX6-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v0, s1
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX6-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX7-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    v_mov_b32_e32 v0, s1
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX7-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX900-SDAG-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    v_mov_b32_e32 v0, s1
; GFX900-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX900-SDAG-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX900-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX900-SDAG-NEXT:    ; return to shader part epilog
;
; GFX950-SDAG-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v0, s1
; GFX950-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX950-SDAG-NEXT:    v_max3_f32 v0, s0, v0, v1
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX950-SDAG-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    v_max3_f32 v0, s0, s1, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_max3_f32 v0, s0, s1, v0
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
;
; GFX12-LABEL: s_max3_f32_maximumnum_maximumnum__s_s_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_max3_num_f32 v0, s0, s1, v0
; GFX12-NEXT:    v_readfirstlane_b32 s0, v0
; GFX12-NEXT:    s_wait_alu 0xf1ff
; GFX12-NEXT:    ; return to shader part epilog
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  %max3.bitcast = bitcast float %max3 to i32
  ret i32 %max3.bitcast
}

define float @v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan(float %a, float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call nnan float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call nnan float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0(float %a, float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call nnan float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define float @v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1(float %a, float %b, float %c) {
; GFX6-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f32_maximumnum_maximumnum__v_v_v_0__nnan1:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %max3 = call nnan float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %max3
}

define <2 x float> @v_max3_v2f32_maximumnum_maximumnum__v_v_v_0(<2 x float> %a, <2 x float> %b, <2 x float> %c) {
; GFX6-LABEL: v_max3_v2f32_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX6-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_v2f32_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX7-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_v2f32_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX8-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_v2f32_maximumnum_maximumnum__v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX9-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_v2f32_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX10-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_v2f32_maximumnum_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX11-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_v2f32_maximumnum_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v2, v4
; GFX12-NEXT:    v_max3_num_f32 v1, v1, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call <2 x float> @llvm.maximumnum.v2f32(<2 x float> %a, <2 x float> %b)
  %max3 = call <2 x float> @llvm.maximumnum.v2f32(<2 x float> %tmp0, <2 x float> %c)
  ret <2 x float> %max3
}

define half @v_max3_f16_maximumnum_maximumnum__v_v_v_0(half %a, half %b, half %c) {
; GFX6-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_max_f16_e32 v1, v2, v2
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f16 v0, v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f16 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_max3_f16 v0.l, v0.l, v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_max3_f16 v0, v0, v1, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX12-SDAG-TRUE16:       ; %bb.0:
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_max3_num_f16 v0.l, v0.l, v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: v_max3_f16_maximumnum_maximumnum__v_v_v_0:
; GFX12-SDAG-FAKE16:       ; %bb.0:
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_max3_num_f16 v0, v0, v1, v2
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call half @llvm.maximumnum.f16(half %a, half %b)
  %max3 = call half @llvm.maximumnum.f16(half %tmp0, half %c)
  ret half %max3
}

define <2 x half> @v_max3_v2f16_maximumnum_maximumnum__v_v_v_0(<2 x half> %a, <2 x half> %b, <2 x half> %c) {
; GFX6-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX6-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_max3_f32 v0, v0, v2, v4
; GFX7-NEXT:    v_max3_f32 v1, v1, v3, v5
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v3, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v4, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v3, v4, v3
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_max_f16_sdwa v1, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v2
; GFX8-NEXT:    v_max_f16_sdwa v1, v3, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v2, v2
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v2, v2
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX10-NEXT:    v_pk_max_f16 v1, v2, v2
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    v_pk_max_f16 v1, v2, v2
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_v2f16_maximumnum_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v1
; GFX12-NEXT:    v_pk_max_num_f16 v1, v2, v2
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call <2 x half> @llvm.maximumnum.v2f16(<2 x half> %a, <2 x half> %b)
  %max3 = call <2 x half> @llvm.maximumnum.v2f16(<2 x half> %tmp0, <2 x half> %c)
  ret <2 x half> %max3
}

define <3 x half> @v_max3_v3f16_maximumnum_maximumnum__v_v_v_0(<3 x half> %a, <3 x half> %b, <3 x half> %c) {
; GFX6-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_max3_f32 v0, v0, v3, v6
; GFX6-NEXT:    v_max3_f32 v1, v1, v4, v7
; GFX6-NEXT:    v_max3_f32 v2, v2, v5, v8
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_max3_f32 v0, v0, v3, v6
; GFX7-NEXT:    v_max3_f32 v1, v1, v4, v7
; GFX7-NEXT:    v_max3_f32 v2, v2, v5, v8
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v6, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v7, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v2
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_max_f16_e32 v2, v3, v3
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v2
; GFX8-NEXT:    v_max_f16_e32 v3, v5, v5
; GFX8-NEXT:    v_max_f16_e32 v6, v7, v6
; GFX8-NEXT:    v_max_f16_sdwa v2, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_max_f16_e32 v3, v4, v4
; GFX8-NEXT:    v_max_f16_sdwa v2, v6, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX900-SDAG-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-SDAG-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-SDAG-NEXT:    v_pk_max_f16 v2, v5, v5
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v1, v2
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX950-SDAG-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX950-SDAG-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX950-SDAG-NEXT:    v_pk_max_f16 v2, v5, v5
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v1, v2
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX10-NEXT:    v_pk_max_f16 v4, v5, v5
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX11-NEXT:    v_pk_max_f16 v4, v5, v5
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_v3f16_maximumnum_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v2
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    v_pk_max_num_f16 v3, v3, v3
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v2, v4, v4
; GFX12-NEXT:    v_pk_max_num_f16 v4, v5, v5
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call <3 x half> @llvm.maximumnum.v3f16(<3 x half> %a, <3 x half> %b)
  %max3 = call <3 x half> @llvm.maximumnum.v3f16(<3 x half> %tmp0, <3 x half> %c)
  ret <3 x half> %max3
}

define <4 x half> @v_max3_v4f16_maximumnum_maximumnum__v_v_v_0(<4 x half> %a, <4 x half> %b, <4 x half> %c) {
; GFX6-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v11, v11
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX6-NEXT:    v_cvt_f16_f32_e32 v10, v10
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v9, v9
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_max3_f32 v0, v0, v4, v8
; GFX6-NEXT:    v_max3_f32 v1, v1, v5, v9
; GFX6-NEXT:    v_max3_f32 v2, v2, v6, v10
; GFX6-NEXT:    v_max3_f32 v3, v3, v7, v11
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v11, v11
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v10, v10
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v9, v9
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_max3_f32 v0, v0, v4, v8
; GFX7-NEXT:    v_max3_f32 v1, v1, v5, v9
; GFX7-NEXT:    v_max3_f32 v2, v2, v6, v10
; GFX7-NEXT:    v_max3_f32 v3, v3, v7, v11
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v6, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v7, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v2
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v6, v7, v6
; GFX8-NEXT:    v_max_f16_sdwa v7, v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v8, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_max_f16_e32 v2, v3, v3
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v7, v8, v7
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v2
; GFX8-NEXT:    v_max_f16_sdwa v2, v5, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v3, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v5, v5, v5
; GFX8-NEXT:    v_max_f16_e32 v4, v4, v4
; GFX8-NEXT:    v_max_f16_sdwa v2, v7, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_sdwa v3, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v5
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX900-SDAG-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-SDAG-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX900-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX900-SDAG-NEXT:    v_pk_max_f16 v2, v5, v5
; GFX900-SDAG-NEXT:    v_pk_max_f16 v1, v1, v2
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX950-SDAG-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX950-SDAG-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX950-SDAG-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX950-SDAG-NEXT:    v_pk_max_f16 v2, v5, v5
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_pk_max_f16 v1, v1, v2
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX10-NEXT:    v_pk_max_f16 v4, v5, v5
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v2, v4, v4
; GFX11-NEXT:    v_pk_max_f16 v4, v5, v5
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_v4f16_maximumnum_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v2
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    v_pk_max_num_f16 v3, v3, v3
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v2, v4, v4
; GFX12-NEXT:    v_pk_max_num_f16 v4, v5, v5
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call <4 x half> @llvm.maximumnum.v4f16(<4 x half> %a, <4 x half> %b)
  %max3 = call <4 x half> @llvm.maximumnum.v4f16(<4 x half> %tmp0, <4 x half> %c)
  ret <4 x half> %max3
}

define double @v_max3_f64_maximumnum_maximumnum__v_v_v_0(double %a, double %b, double %c) {
; GFX6-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX6-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX6-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX6-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX6-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX7-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX7-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX7-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX900-SDAG-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX900-SDAG-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX900-SDAG-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX900-SDAG-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX950-SDAG-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX950-SDAG-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX950-SDAG-NEXT:    v_max_f64 v[2:3], v[4:5], v[4:5]
; GFX950-SDAG-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_max3_f64_maximumnum_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[4:5]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call double @llvm.maximumnum.f64(double %a, double %b)
  %max3 = call double @llvm.maximumnum.f64(double %tmp0, double %c)
  ret double %max3
}

define bfloat @v_max3_bf16_maximumnum_maximumnum__v_v_v_0(bfloat %a, bfloat %b, bfloat %c) {
; GFX6-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX900-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX900-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v1, v3
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v1, v2, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX900-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX950-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v4
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX950-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v1, v3
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v2, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX950-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v2, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v1, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v4
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.l, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v4
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v3, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v2, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX12-SDAG-TRUE16:       ; %bb.0:
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v1, v1
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, s0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v2.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.l, v0.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, v0.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, v0.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: v_max3_bf16_maximumnum_maximumnum__v_v_v_0:
; GFX12-SDAG-FAKE16:       ; %bb.0:
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v4
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v3, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v2, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call bfloat @llvm.maximumnum.bf16(bfloat %a, bfloat %b)
  %max3 = call bfloat @llvm.maximumnum.bf16(bfloat %tmp0, bfloat %c)
  ret bfloat %max3
}

define <2 x bfloat> @v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0(<2 x bfloat> %a, <2 x bfloat> %b, <2 x bfloat> %c) {
; GFX6-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX6-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX6-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v4
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v4
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_sdwa v4, v0, v3, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v3, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v4
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-SDAG-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX900-SDAG:       ; %bb.0:
; GFX900-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX900-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX900-SDAG-NEXT:    v_cndmask_b32_sdwa v4, v0, v3, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX900-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v6
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v5, v3, v4, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX900-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX900-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v4, v1, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v4
; GFX900-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX900-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX900-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX900-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v5
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v3, v4, v1, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX900-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX900-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v4
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX900-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-SDAG-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-SDAG-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-SDAG-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX950-SDAG:       ; %bb.0:
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-SDAG-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX950-SDAG-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX950-SDAG-NEXT:    v_cndmask_b32_sdwa v4, v0, v3, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX950-SDAG-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX950-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v6
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v5, v3, v4, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX950-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX950-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX950-SDAG-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v4, v1, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v4
; GFX950-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX950-SDAG-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX950-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v5
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v3, v4, v1, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX950-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-SDAG-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-SDAG-NEXT:    s_nop 0
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX950-SDAG-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v4
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-SDAG-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX950-SDAG-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-SDAG-NEXT:    s_nop 1
; GFX950-SDAG-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-SDAG-NEXT:    v_perm_b32 v0, v1, v0, s0
; GFX950-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cndmask_b32_sdwa v7, v0, v3, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v3, v7, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v4, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v6, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX10-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX11-SDAG-TRUE16:       ; %bb.0:
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v4, v4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v6, v6
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v3.l, v0.h, v1.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v4.l, v1.h, v3.l, s1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v0.l, s2
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v7
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v6, v8
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v5.l, v4.l, v3.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v6.l, v1.l, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v6.l
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v5.l, v3.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v4.l, s1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s2
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v7
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v0.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v6, v6
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v4, v4
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v2.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v3.l, v2.h, v1.l, s1
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s2
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v6
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v7
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v1.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.l, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v1.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v3.l, s1
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v6
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v0.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX11-SDAG-FAKE16:       ; %bb.0:
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v5, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v4, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v1, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v4 :: v_dual_lshlrev_b32 v4, 16, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v6, v0 :: v_dual_lshlrev_b32 v3, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v5
; GFX11-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v4, v1 :: v_dual_lshlrev_b32 v6, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v7
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v2, v0 :: v_dual_lshlrev_b32 v6, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX12-SDAG-TRUE16:       ; %bb.0:
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v4, v4
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v6, v6
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v3.l, v0.h, v1.h, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v4.l, v1.h, v3.l, s1
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v0.l, s2
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v7
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v6, v8
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v5.l, v4.l, v3.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v6.l, v1.l, v0.l, s0
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v6.l
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v5.l, v3.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s0
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v4.l, s1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s2
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v7
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v0.h, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v6, v6
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v4, v4
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v2.h, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s0
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v3.l, v2.h, v1.l, s1
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s2
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v6
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v7
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v1.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.l, v0.l, s0
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v1.l, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v6
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v3.l, s1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s2
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v6
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v0.h, vcc_lo
; GFX12-SDAG-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: v_max3_v2bf16_maximumnum_maximumnum__v_v_v_0:
; GFX12-SDAG-FAKE16:       ; %bb.0:
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v0
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v5, v4, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v3, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v6
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v4, v3, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v1, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v4 :: v_dual_lshlrev_b32 v4, 16, v6
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v6, v0 :: v_dual_lshlrev_b32 v3, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v5
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v4, v1 :: v_dual_lshlrev_b32 v6, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v7
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v2, v0 :: v_dual_lshlrev_b32 v6, 16, v3
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %tmp0 = call <2 x bfloat> @llvm.maximumnum.v2bf16(<2 x bfloat> %a, <2 x bfloat> %b)
  %max3 = call <2 x bfloat> @llvm.maximumnum.v2bf16(<2 x bfloat> %tmp0, <2 x bfloat> %c)
  ret <2 x bfloat> %max3
}

define float @v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, -v0, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, -v0, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, -v0, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, -v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, -v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, -v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_maximumnum__neg_v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, -v0, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %neg.a = fneg float %a
  %tmp0 = call float @llvm.maximumnum.f32(float %neg.a, float %b)
  %min3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %min3
}

define float @v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, -v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, -v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, -v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, -v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, -v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, -v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_maximumnum__v_neg_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, -v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %neg.b = fneg float %b
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %neg.b)
  %min3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %min3
}

define float @v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, v0, v1, -v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, v0, v1, -v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, v0, v1, -v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, v0, v1, -v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, v0, v1, -v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, -v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_maximumnum__v_v_neg_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, v0, v1, -v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %neg.c = fneg float %c
  %tmp0 = call float @llvm.maximumnum.f32(float %a, float %b)
  %min3 = call float @llvm.maximumnum.f32(float %tmp0, float %neg.c)
  ret float %min3
}

define float @v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, -|v0|, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, -|v0|, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, -|v0|, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, -|v0|, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, -|v0|, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, -|v0|, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, -|v0|, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.a = call float @llvm.fabs.f32(float %a)
  %neg.fabs.a = fneg float %fabs.a
  %tmp0 = call float @llvm.maximumnum.f32(float %neg.fabs.a, float %b)
  %min3 = call float @llvm.maximumnum.f32(float %tmp0, float %c)
  ret float %min3
}

define float @v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, -|v0|, -|v1|, -|v2|
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, -|v0|, -|v1|, -|v2|
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, -|v0|, -|v1|, -|v2|
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, -|v0|, -|v1|, -|v2|
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, -|v0|, -|v1|, -|v2|
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, -|v0|, -|v1|, -|v2|
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_maximumnum__neg_fabs_v_neg_fabs_v_neg_fabs_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, -|v0|, -|v1|, -|v2|
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.a = call float @llvm.fabs.f32(float %a)
  %neg.fabs.a = fneg float %fabs.a
  %fabs.b = call float @llvm.fabs.f32(float %b)
  %neg.fabs.b = fneg float %fabs.b
  %fabs.c = call float @llvm.fabs.f32(float %c)
  %neg.fabs.c = fneg float %fabs.c

  %tmp0 = call float @llvm.maximumnum.f32(float %neg.fabs.a, float %neg.fabs.b)
  %min3 = call float @llvm.maximumnum.f32(float %tmp0, float %neg.fabs.c)
  ret float %min3
}

define float @v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_minmax_f32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_neg_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, -v1, -v1
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v0
; GFX12-NEXT:    v_max_num_f32_e32 v2, v2, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_minmax_num_f32 v0, v0, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %neg.a = fneg float %a
  %tmp0 = call float @llvm.maximumnum.f32(float %neg.a, float %b)
  %neg.tmp0 = fneg float %tmp0
  %min3 = call float @llvm.maximumnum.f32(float %neg.tmp0, float %c)
  ret float %min3
}

define float @v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX10-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX11-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v1 :: v_dual_max_f32 v1, v2, v2
; GFX11-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_fabs_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v1, v1, v1
; GFX12-NEXT:    v_max_num_f32_e64 v0, -v0, -v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v1 :: v_dual_max_num_f32 v1, v2, v2
; GFX12-NEXT:    v_and_b32_e32 v0, 0x7fffffff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %neg.a = fneg float %a
  %tmp0 = call float @llvm.maximumnum.f32(float %neg.a, float %b)
  %abs.tmp0 = call float @llvm.fabs.f32(float %tmp0)
  %min3 = call float @llvm.maximumnum.f32(float %abs.tmp0, float %c)
  ret float %min3
}

define float @v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0(float %a, float %b, float %c) {
; GFX6-LABEL: v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_or_b32_e32 v0, 0x80000000, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX6-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_or_b32_e32 v0, 0x80000000, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, 0x80000000, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v2
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_or_b32_e32 v0, 0x80000000, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_max_f32_e32 v1, v2, v2
; GFX10-NEXT:    v_or_b32_e32 v0, 0x80000000, v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX11-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v1 :: v_dual_max_f32 v1, v2, v2
; GFX11-NEXT:    v_or_b32_e32 v0, 0x80000000, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_f32_maximumnum_fneg_fabs_maximumnum__v_v_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v1, v1, v1
; GFX12-NEXT:    v_max_num_f32_e64 v0, -v0, -v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v1 :: v_dual_max_num_f32 v1, v2, v2
; GFX12-NEXT:    v_or_b32_e32 v0, 0x80000000, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %neg.a = fneg float %a
  %tmp0 = call float @llvm.maximumnum.f32(float %neg.a, float %b)
  %abs.tmp0 = call float @llvm.fabs.f32(float %tmp0)
  %neg.abs.tmp0 = fneg float %abs.tmp0
  %min3 = call float @llvm.maximumnum.f32(float %neg.abs.tmp0, float %c)
  ret float %min3
}

define <2 x float> @v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0(<2 x float> %a, <2 x float> %b, <2 x float> %c) {
; GFX6-LABEL: v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_max3_f32 v0, -v0, -v2, -v4
; GFX6-NEXT:    v_max3_f32 v1, -v1, -v3, -v5
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_max3_f32 v0, -v0, -v2, -v4
; GFX7-NEXT:    v_max3_f32 v1, -v1, -v3, -v5
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max3_f32 v0, -v0, -v2, -v4
; GFX8-NEXT:    v_max3_f32 v1, -v1, -v3, -v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max3_f32 v0, -v0, -v2, -v4
; GFX9-NEXT:    v_max3_f32 v1, -v1, -v3, -v5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max3_f32 v0, -v0, -v2, -v4
; GFX10-NEXT:    v_max3_f32 v1, -v1, -v3, -v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, -v0, -v2, -v4
; GFX11-NEXT:    v_max3_f32 v1, -v1, -v3, -v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_min3_v2f32_maximumnum_maximumnum__neg_v_neg_v_neg_v_0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max3_num_f32 v0, -v0, -v2, -v4
; GFX12-NEXT:    v_max3_num_f32 v1, -v1, -v3, -v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %neg.a = fneg <2 x float> %a
  %neg.b = fneg <2 x float> %b
  %neg.c = fneg <2 x float> %c
  %tmp0 = call <2 x float> @llvm.maximumnum.v2f32(<2 x float> %neg.a, <2 x float> %neg.b)
  %min3 = call <2 x float> @llvm.maximumnum.v2f32(<2 x float> %tmp0, <2 x float> %neg.c)
  ret <2 x float> %min3
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10-SDAG: {{.*}}
; GFX11-SDAG: {{.*}}
; GFX12-SDAG: {{.*}}
; GFX6-SDAG: {{.*}}
; GFX7-SDAG: {{.*}}
; GFX8-SDAG: {{.*}}
; GFX9-SDAG: {{.*}}
; GFX950: {{.*}}
