////////////////////////////////////////////////////////////////////////
//
// Copyright (C) 2013-2026 The Octave Project Developers
//
// See the file COPYRIGHT.md in the top-level directory of this
// distribution or <https://octave.org/copyright/>.
//
// This file is part of Octave.
//
// Octave is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Octave is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Octave; see the file COPYING.  If not, see
// <https://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////

#if defined (HAVE_CONFIG_H)
#  include "config.h"
#endif

#include <string>

#include "version.h"

static std::string
format_url (bool html, const std::string& url)
{
  if (html)
    return R"(<a href=")" + url + R"(">)" + url + "</a>";
  else
    return "<" + url + ">";
}

std::string
octave_www_statement (bool html)
{
  return "Home page:            "
         + format_url (html, "https://octave.org");
}

std::string
octave_bugs_statement (bool html)
{
  return "Support resources:    "
         + format_url (html, "https://octave.org/support");
}

std::string
octave_contrib_statement (bool html)
{
  return "Improve Octave:       "
         + format_url (html, "https://octave.org/get-involved");
}

std::string
octave_name_version_copyright (bool html)
{
  // The GNU coding standards say that the first line printed by --version
  // should place the version number following the last space on the line.
  std::string br = (html ? "<br>\n" : "\n");

  return "GNU Octave (" OCTAVE_CANONICAL_HOST_TYPE ") version " OCTAVE_VERSION + br
         + OCTAVE_COPYRIGHT;
}

std::string
octave_name_version_copyright_license (bool html)
{
  std::string br = (html ? "<br>\n" : "\n");

  return octave_name_version_copyright (html) + br
         + "License GPLv3+: GNU GPL version 3 or later "
         + format_url (html, "https://gnu.org/licenses/gpl.html");
}

static std::string
octave_warranty_statement (bool html, const std::string& extra_info = "")
{
  std::string br = (html ? "\n" : "\n");

  return "There is NO WARRANTY, to the extent permitted by law."
         + extra_info;
}

std::string
octave_name_version_copyright_license_copying_warranty
  (bool html, const std::string& extra_info)
{
  std::string br = (html ? "<br>\n" : "\n");
  std::string sep = (html ? "\n</p>\n<p>\n" : "\n\n");

  return octave_name_version_copyright_license (html)
         + sep
         + "This is free software; see the source code for copying conditions." + br
         + octave_warranty_statement (html, extra_info) ;
}

std::string
octave_name_version_copyright_license_copying_warranty_bugs
  (bool html, const std::string& extra_info)
{
  std::string sep = (html ? "\n</p>\n<p>\n" : "\n");
  std::string msg =
    (html ? "<p>\n" : "")
    + octave_name_version_copyright_license_copying_warranty (html, extra_info)
    + (html ? "" : "\n")               + sep
    + octave_www_statement (html)      + sep
    + octave_bugs_statement (html)     + sep
    + octave_contrib_statement (html)  + sep
    + (html ? "\n</p>" : "");

  return msg;
}

std::string
octave_startup_message (bool html)
{
  std::string msg
    = octave_name_version_copyright_license_copying_warranty_bugs
        (html, "  For details, type 'warranty'.");

  msg += (html ? "<p>\n" : "\n");
  msg += "For changes from previous versions, type 'news'.";
  msg += (html ? "\n</p>" : "");

  return msg;
}
