/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a*\u0010\t\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"canonicalizePath", "", "url", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "", "isValidPath", "path", "canonicalizeUrl", "trimFileScheme", "doCanonicalize", "asLocalFileIfAbsoluteAndExists", "intellij.platform.scriptDebugger.backend"})
public final class SourceResolverKt {
    @NotNull
    public static final String canonicalizePath(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Object path = url;
        if (!FileUtil.isAbsolute((String)url) && ((CharSequence)url).length() > 0 && url.charAt(0) != '/') {
            String string2 = ScriptDebuggerUrls.INSTANCE.toFilePath(baseUrl);
            if (string2 == null) {
                String string3 = baseUrl.getPath();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            }
            String basePath = string2;
            if (baseUrlIsFile) {
                int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)basePath, (char)'/', (int)0, (boolean)false, (int)6, null);
                StringBuilder pathBuilder = new StringBuilder();
                StringBuilder stringBuilder = lastSlashIndex == -1 ? pathBuilder.append('/') : pathBuilder.append(basePath, 0, lastSlashIndex + 1);
                path = pathBuilder.append(url).toString();
                boolean resolveSymlinks = SourceResolverKt.isValidPath((String)path);
                String string4 = FileUtil.toCanonicalPath((String)path, (boolean)resolveSymlinks);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toCanonicalPath(...)");
                return string4;
            }
            path = basePath + "/" + url;
        }
        String string5 = FileUtil.toCanonicalPath((String)path, (char)'/');
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toCanonicalPath(...)");
        return string5;
    }

    private static final boolean isValidPath(String path) {
        boolean bl;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(path, new String[0]), (String)"get(...)");
            bl = true;
        }
        catch (InvalidPathException invalidPathException) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean trimFileScheme, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
            return ScriptDebuggerUrls.INSTANCE.toLocalFileUrl(url);
        }
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"data:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"blob:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"javascript:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"webpack:", (boolean)false, (int)2, null)) {
            Url url2 = Urls.parseEncoded((String)url);
            if (url2 == null) {
                url2 = Urls.newUri(null, (String)url);
            }
            return url2;
        }
        return SourceResolverKt.doCanonicalize(url, baseUrl, baseUrlIsFile, true);
    }

    public static /* synthetic */ Url canonicalizeUrl$default(String string2, Url url, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return SourceResolverKt.canonicalizeUrl(string2, url, bl, bl2);
    }

    @NotNull
    public static final Url doCanonicalize(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile, boolean asLocalFileIfAbsoluteAndExists) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        String path = SourceResolverKt.canonicalizePath(url, baseUrl, baseUrlIsFile);
        if (baseUrl.isInLocalFileSystem() || asLocalFileIfAbsoluteAndExists && SourceResolver.Companion.isAbsolute(path) && new File(path).exists()) {
            return ScriptDebuggerUrls.newLocalFileUrl(path);
        }
        if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            Url url2 = ScriptDebuggerUrls.parse(path, true);
            if (url2 == null) {
                url2 = Urls.newUnparsable((String)path);
            }
            return url2;
        }
        char[] cArray = new char[]{'?'};
        List split = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        String string3 = baseUrl.getScheme();
        String string4 = baseUrl.getAuthority();
        String string5 = (String)split.get(0);
        if (split.size() > 1) {
            char c = '?';
            String string6 = (String)split.get(1);
            string2 = c + string6;
        } else {
            string2 = null;
        }
        return Urls.newUrl((String)string3, (String)string4, (String)string5, string2);
    }
}

