/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H'J4\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u0010H'J6\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u0010H\u0017J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0019H\u0017J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0010H'J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0019H&J \u0010)\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0017JB\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u0010H\u0017J\u0012\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020'H'J\u0012\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020'H'J\u0012\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H'R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006/\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMap;", "", "outFile", "", "getOutFile", "()Ljava/lang/String;", "sources", "", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "hasNameMappings", "", "getHasNameMappings", "()Z", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "findSourceMappings", "sourceIndex", "", "findSourceIndex", "sourceUrl", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "localFileUrlOnly", "getSourceLineByRawLocation", "rawLine", "rawColumn", "getSourceMappingsInLine", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "sourceLine", "processSourceMappingsInLine", "mappingProcessor", "Lorg/jetbrains/debugger/sourcemap/MappingsProcessorInLine;", "getRawSource", "entry", "getSourceContent", "intellij.platform.scriptDebugger.backend"})
public interface SourceMap {
    @ApiStatus.Internal
    @Nullable
    public String getOutFile();

    @ApiStatus.Internal
    @NotNull
    public Url[] getSources();

    @ApiStatus.Internal
    @NotNull
    public Mappings getGeneratedMappings();

    @ApiStatus.Internal
    public boolean getHasNameMappings();

    @ApiStatus.Internal
    @NotNull
    public SourceResolver getSourceResolver();

    @ApiStatus.Internal
    @NotNull
    public Mappings findSourceMappings(int var1);

    @ApiStatus.Internal
    public int findSourceIndex(@NotNull Url var1, @Nullable VirtualFile var2, @Nullable Lazy<? extends SourceFileResolver> var3, boolean var4);

    @ApiStatus.Internal
    @Nullable
    default public Mappings findSourceMappings(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        int sourceIndex = this.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
        return sourceIndex >= 0 ? this.findSourceMappings(sourceIndex) : null;
    }

    @ApiStatus.Internal
    default public int getSourceLineByRawLocation(int rawLine, int rawColumn) {
        MappingEntry mappingEntry = this.getGeneratedMappings().get(rawLine, rawColumn);
        return mappingEntry != null ? mappingEntry.getSourceLine() : -1;
    }

    @ApiStatus.Internal
    public int findSourceIndex(@NotNull VirtualFile var1, boolean var2);

    @NotNull
    public Iterable<MappingEntry> getSourceMappingsInLine(int var1, int var2);

    @ApiStatus.Internal
    default public boolean processSourceMappingsInLine(int sourceIndex, int sourceLine, @NotNull MappingsProcessorInLine mappingProcessor) {
        Intrinsics.checkNotNullParameter((Object)mappingProcessor, (String)"mappingProcessor");
        return mappingProcessor.processIterable(this.getSourceMappingsInLine(sourceIndex, sourceLine));
    }

    @ApiStatus.Internal
    @NotNull
    default public Iterable<MappingEntry> getSourceMappingsInLine(@NotNull Url sourceUrl, int sourceLine, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        int sourceIndex = this.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
        return sourceIndex >= 0 ? this.getSourceMappingsInLine(sourceIndex, sourceLine) : (Iterable<MappingEntry>)CollectionsKt.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public String getRawSource(@NotNull MappingEntry var1);

    @ApiStatus.Internal
    @Nullable
    public String getSourceContent(@NotNull MappingEntry var1);

    @ApiStatus.Internal
    @Nullable
    public String getSourceContent(int var1);
}

