/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.sax;

import com.thaiopensource.util.UriOrFile;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final PrintWriter err;
    private final String bundleName = "com.thaiopensource.xml.sax.resources.Messages";
    private ResourceBundle bundle = null;

    public ErrorHandlerImpl() {
        this(System.err);
    }

    public ErrorHandlerImpl(OutputStream outputStream) {
        this.err = new PrintWriter(outputStream);
    }

    public ErrorHandlerImpl(Writer writer) {
        this.err = new PrintWriter(writer);
    }

    public void close() {
        this.err.close();
    }

    private String getString(String string2) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.thaiopensource.xml.sax.resources.Messages");
        }
        return this.bundle.getString(string2);
    }

    private String format(String string2, Object[] objectArray) {
        return MessageFormat.format(this.getString(string2), objectArray);
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this.print(this.format("warning", new Object[]{this.formatMessage(sAXParseException), this.formatLocation(sAXParseException)}));
    }

    public void error(SAXParseException sAXParseException) {
        this.print(this.format("error", new Object[]{this.formatMessage(sAXParseException), this.formatLocation(sAXParseException)}));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void printException(Throwable throwable) {
        String string2 = throwable instanceof SAXParseException ? this.formatLocation((SAXParseException)throwable) : "";
        String string3 = throwable instanceof SAXException ? this.formatMessage((SAXException)throwable) : this.formatMessage(throwable);
        this.print(this.format("fatal", new Object[]{string3, string2}));
    }

    public void print(String string2) {
        if (string2.length() != 0) {
            this.err.println(string2);
            this.err.flush();
        }
    }

    private String formatLocation(SAXParseException sAXParseException) {
        Integer n;
        String string2 = sAXParseException.getSystemId();
        int n2 = sAXParseException.getLineNumber();
        Integer n3 = n2 >= 0 ? new Integer(n2) : null;
        n2 = sAXParseException.getColumnNumber();
        Integer n4 = n = n2 >= 0 ? new Integer(n2) : null;
        if (string2 != null) {
            string2 = UriOrFile.uriToUriOrFile(string2);
            if (n3 != null) {
                if (n != null) {
                    return this.format("locator_system_id_line_number_column_number", new Object[]{string2, n3, n});
                }
                return this.format("locator_system_id_line_number", new Object[]{string2, n3});
            }
            return this.format("locator_system_id", new Object[]{string2});
        }
        if (n3 != null) {
            if (n != null) {
                return this.format("locator_line_number_column_number", new Object[]{n3, n});
            }
            return this.format("locator_line_number", new Object[]{n3});
        }
        return "";
    }

    private String formatMessage(SAXException sAXException) {
        Exception exception = sAXException.getException();
        String string2 = sAXException.getMessage();
        if (exception != null) {
            String string3 = exception.getMessage();
            if (string3 == string2 || exception.getClass().getName().equals(string2)) {
                return this.formatMessage(exception);
            }
            if (string3 == null) {
                return this.format("exception", new Object[]{exception.getClass().getName(), string2});
            }
            return this.format("tunnel_exception", new Object[]{exception.getClass().getName(), string2, string3});
        }
        if (string2 == null) {
            string2 = this.getString("no_detail");
        }
        return string2;
    }

    private String formatMessage(Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = this.getString("no_detail");
        }
        if (throwable instanceof FileNotFoundException) {
            return this.format("file_not_found", new Object[]{string2});
        }
        return this.format("exception", new Object[]{throwable.getClass().getName(), string2});
    }
}

