/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.xsd.ChildType;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RestrictionsChecker {
    private final SchemaInfo si;
    private final ErrorReporter er;
    private final Set checkedPatterns = new HashSet();
    private static final int DISALLOW_ELEMENT = 1;
    private static final int DISALLOW_ATTRIBUTE = 2;
    private static final int DISALLOW_LIST = 4;
    private static final int DISALLOW_TEXT = 8;
    private static final int DISALLOW_EMPTY = 16;
    private static final int DISALLOW_DATA = 32;
    private static final int DISALLOW_GROUP = 64;
    private static final int DISALLOW_INTERLEAVE = 128;
    private static final int DISALLOW_ONE_OR_MORE = 256;
    private static final int START_DISALLOW = 510;
    private static final int LIST_DISALLOW = 143;
    private static final int DATA_EXCEPT_DISALLOW = 479;
    private static final int ATTRIBUTE_DISALLOW = 3;
    private final PatternVisitor startVisitor = new Visitor("start", 510);
    private final PatternVisitor topLevelVisitor = new ListVisitor(null, 0);
    private final PatternVisitor elementVisitor = new ElementVisitor();
    private final PatternVisitor elementRepeatVisitor = new ElementRepeatVisitor();
    private final PatternVisitor elementRepeatGroupVisitor = new Visitor("element_repeat_group", 2);
    private final PatternVisitor elementRepeatInterleaveVisitor = new Visitor("element_repeat_interleave", 2);
    private final PatternVisitor attributeVisitor = new Visitor("attribute", 3);
    private final PatternVisitor listVisitor = new ListVisitor("list", 143);
    private final PatternVisitor dataExceptVisitor = new Visitor("data_except", 479);

    private RestrictionsChecker(SchemaInfo schemaInfo, ErrorReporter errorReporter) {
        this.si = schemaInfo;
        this.er = errorReporter;
        Pattern pattern = schemaInfo.getStart();
        if (pattern != null) {
            pattern.accept(this.startVisitor);
        }
        schemaInfo.getGrammar().componentsAccept(new GrammarVisitor());
    }

    static void check(SchemaInfo schemaInfo, ErrorReporter errorReporter) {
        new RestrictionsChecker(schemaInfo, errorReporter);
    }

    private boolean alreadyChecked(Pattern pattern) {
        if (this.checkedPatterns.contains(pattern)) {
            return true;
        }
        this.checkedPatterns.add(pattern);
        return false;
    }

    class GrammarVisitor
    implements ComponentVisitor {
        GrammarVisitor() {
        }

        public Object visitDiv(DivComponent divComponent) {
            divComponent.componentsAccept(this);
            return null;
        }

        public Object visitDefine(DefineComponent defineComponent) {
            if (defineComponent.getName() != DefineComponent.START) {
                defineComponent.getBody().accept(RestrictionsChecker.this.topLevelVisitor);
            }
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            RestrictionsChecker.this.si.getSchema(includeComponent.getHref()).componentsAccept(this);
            return null;
        }
    }

    class ElementRepeatVisitor
    extends Visitor {
        ElementRepeatVisitor() {
            super(null, 0);
        }

        public Object visitGroup(GroupPattern groupPattern) {
            return RestrictionsChecker.this.elementRepeatGroupVisitor.visitGroup(groupPattern);
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            return RestrictionsChecker.this.elementRepeatInterleaveVisitor.visitInterleave(interleavePattern);
        }
    }

    class ElementVisitor
    extends Visitor {
        ElementVisitor() {
            super(null, 0);
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            attributePattern.getNameClass().accept(this);
            return super.visitAttribute(attributePattern);
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return RestrictionsChecker.this.elementRepeatVisitor.visitZeroOrMore(zeroOrMorePattern);
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return RestrictionsChecker.this.elementRepeatVisitor.visitOneOrMore(oneOrMorePattern);
        }

        public Object visitAnyName(AnyNameNameClass anyNameNameClass) {
            RestrictionsChecker.this.er.error("any_name_attribute_not_repeated", anyNameNameClass.getSourceLocation());
            return null;
        }

        public Object visitNsName(NsNameNameClass nsNameNameClass) {
            RestrictionsChecker.this.er.error("ns_name_attribute_not_repeated", nsNameNameClass.getSourceLocation());
            return null;
        }
    }

    class ListVisitor
    extends Visitor {
        public ListVisitor(String string2, int n) {
            super(string2, n);
        }

        boolean inList() {
            return true;
        }
    }

    class Visitor
    extends AbstractVisitor {
        private final String contextKey;
        private final int flags;

        Visitor(String string2, int n) {
            this.contextKey = string2;
            this.flags = n;
        }

        private boolean checkContext(int n, String string2, Pattern pattern) {
            if ((this.flags & n) != 0) {
                RestrictionsChecker.this.er.error("illegal_contains", RestrictionsChecker.this.er.getLocalizer().message(this.contextKey), string2, pattern.getSourceLocation());
                return false;
            }
            return true;
        }

        public Object visitGroup(GroupPattern groupPattern) {
            if (this.checkContext(64, "group", groupPattern)) {
                this.checkGroup(groupPattern);
                super.visitGroup(groupPattern);
            }
            return null;
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            if (this.checkContext(128, "interleave", interleavePattern)) {
                this.checkGroup(interleavePattern);
                super.visitInterleave(interleavePattern);
            }
            return null;
        }

        public Object visitElement(ElementPattern elementPattern) {
            if (this.checkContext(1, "element", elementPattern) && !RestrictionsChecker.this.alreadyChecked(elementPattern)) {
                elementPattern.getChild().accept(RestrictionsChecker.this.elementVisitor);
            }
            return null;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            if (this.checkContext(2, "attribute", attributePattern) && !RestrictionsChecker.this.alreadyChecked(attributePattern)) {
                attributePattern.getChild().accept(RestrictionsChecker.this.attributeVisitor);
            }
            return null;
        }

        public Object visitData(DataPattern dataPattern) {
            Pattern pattern;
            if (this.checkContext(32, "data", dataPattern) && !RestrictionsChecker.this.alreadyChecked(dataPattern) && (pattern = dataPattern.getExcept()) != null) {
                pattern.accept(RestrictionsChecker.this.dataExceptVisitor);
            }
            return null;
        }

        public Object visitValue(ValuePattern valuePattern) {
            this.checkContext(32, "value", valuePattern);
            return null;
        }

        public Object visitList(ListPattern listPattern) {
            if (this.checkContext(4, "list", listPattern) && !RestrictionsChecker.this.alreadyChecked(listPattern)) {
                listPattern.getChild().accept(RestrictionsChecker.this.listVisitor);
            }
            return null;
        }

        public Object visitEmpty(EmptyPattern emptyPattern) {
            this.checkContext(16, "empty", emptyPattern);
            return null;
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            if (this.checkContext(16, "optional", optionalPattern)) {
                super.visitOptional(optionalPattern);
            }
            return null;
        }

        public Object visitText(TextPattern textPattern) {
            this.checkContext(8, "text", textPattern);
            return null;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            if (this.checkContext(8, "mixed", mixedPattern)) {
                if (RestrictionsChecker.this.si.getChildType(mixedPattern.getChild()).contains(ChildType.DATA)) {
                    RestrictionsChecker.this.er.error("mixed_data", mixedPattern.getSourceLocation());
                }
                super.visitMixed(mixedPattern);
            }
            return null;
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            if (this.checkContext(256, "oneOrMore", oneOrMorePattern)) {
                this.checkNoDataUnlessInList(oneOrMorePattern, "oneOrMore");
                super.visitOneOrMore(oneOrMorePattern);
            }
            return null;
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            if (this.checkContext(256, "zeroOrMore", zeroOrMorePattern)) {
                this.checkNoDataUnlessInList(zeroOrMorePattern, "zeroOrMore");
                super.visitZeroOrMore(zeroOrMorePattern);
            }
            return null;
        }

        public Object visitRef(RefPattern refPattern) {
            return RestrictionsChecker.this.si.getBody(refPattern).accept(this);
        }

        void checkNoDataUnlessInList(UnaryPattern unaryPattern, String string2) {
            if (!this.inList() && RestrictionsChecker.this.si.getChildType(unaryPattern.getChild()).contains(ChildType.DATA)) {
                RestrictionsChecker.this.er.error("not_in_list", string2, unaryPattern.getSourceLocation());
            }
        }

        void checkGroup(CompositePattern compositePattern) {
            int n = 0;
            boolean bl = false;
            Iterator iterator = compositePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                ChildType childType = RestrictionsChecker.this.si.getChildType((Pattern)iterator.next());
                boolean bl3 = childType.contains(ChildType.DATA);
                boolean bl4 = bl2 = childType.contains(ChildType.TEXT) || childType.contains(ChildType.ELEMENT);
                if (bl2 && n > 0 || bl3 && bl) {
                    RestrictionsChecker.this.er.error("group_data_other_children", compositePattern instanceof GroupPattern ? "group" : "interleave", compositePattern.getSourceLocation());
                    return;
                }
                if (bl3) {
                    ++n;
                }
                if (!bl2) continue;
                bl = true;
            }
            if (n > 1) {
                if (compositePattern instanceof InterleavePattern) {
                    RestrictionsChecker.this.er.error("interleave_data", compositePattern.getSourceLocation());
                } else if (!this.inList()) {
                    RestrictionsChecker.this.er.error("group_data", compositePattern.getSourceLocation());
                }
            }
        }

        boolean inList() {
            return false;
        }
    }
}

