/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.NamedObjectDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSTypeDescriptorProvider;
import com.intellij.xml.impl.schema.XsdEnumerationDescriptor;
import com.intellij.xml.util.XmlEnumeratedReferenceSet;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementDescriptorImpl
extends XsdEnumerationDescriptor<XmlTag>
implements XmlElementDescriptor,
PsiWritableMetaData,
Validator<XmlTag>,
XmlElementDescriptorAwareAboutChildren {
    protected XmlTag myDescriptorTag;
    protected volatile XmlNSDescriptor NSDescriptor;
    @Nullable
    private volatile Validator<XmlTag> myValidator;
    @NonNls
    public static final String QUALIFIED_ATTR_VALUE = "qualified";
    @NonNls
    public static final String NONQUALIFIED_ATTR_VALUE = "unqualified";
    @NonNls
    private static final String ELEMENT_FORM_DEFAULT = "elementFormDefault";

    public XmlElementDescriptorImpl(@Nullable XmlTag descriptorTag) {
        this.myDescriptorTag = descriptorTag;
    }

    public XmlElementDescriptorImpl() {
    }

    @Override
    public XmlTag getDeclaration() {
        return this.myDescriptorTag;
    }

    public String getName(PsiElement context) {
        Object value = this.myDescriptorTag.getAttributeValue("name");
        if (context instanceof XmlElement) {
            String namespacePrefix;
            String namespace = this.getNamespaceByContext(context);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
            if (tag != null && (namespacePrefix = tag.getPrefixByNamespace(namespace)) != null && !namespacePrefix.isEmpty()) {
                XmlTag rootTag = ((XmlFile)this.myDescriptorTag.getContainingFile()).getRootTag();
                value = !this.isQualifiedForm() && tag.getNamespaceByPrefix("").isEmpty() && this.myDescriptorTag.getParentTag() != rootTag ? XmlUtil.findLocalNameByQualifiedName((String)value) : namespacePrefix + ":" + XmlUtil.findLocalNameByQualifiedName((String)value);
            }
        }
        return value;
    }

    public String getName() {
        return XmlUtil.findLocalNameByQualifiedName(this.getName(null));
    }

    public String getNamespaceByContext(PsiElement context) {
        return this.getNamespace();
    }

    public String getNamespace() {
        String name = this.getName();
        if (name == null) {
            return "";
        }
        if (this.getNSDescriptor() == null || this.myDescriptorTag == null) {
            return "";
        }
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name);
        return namespacePrefix.isEmpty() ? this.getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
    }

    public void init(PsiElement element) {
        if (this.myDescriptorTag != element && this.myDescriptorTag != null) {
            this.NSDescriptor = null;
        }
        this.myDescriptorTag = (XmlTag)element;
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = new Object[]{this.myDescriptorTag};
        if (objectArray == null) {
            XmlElementDescriptorImpl.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private XmlNSDescriptor getNSDescriptor(XmlElement context) {
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        if (context instanceof XmlTag) {
            XmlTag tag = (XmlTag)context;
            if (nsDescriptor instanceof XmlNSDescriptorImpl) {
                String defaultNamespace = ((XmlNSDescriptorImpl)nsDescriptor).getDefaultNamespace();
                if ("http://www.w3.org/2001/XMLSchema".equals(defaultNamespace)) {
                    return nsDescriptor;
                }
                String tagNs = tag.getNamespace();
                if (tagNs.equals(defaultNamespace)) {
                    XmlNSDescriptor previousDescriptor = nsDescriptor;
                    nsDescriptor = tag.getNSDescriptor(tagNs, true);
                    if (nsDescriptor == null) {
                        nsDescriptor = previousDescriptor;
                    }
                }
            }
        }
        return nsDescriptor;
    }

    @Override
    public XmlNSDescriptor getNSDescriptor() {
        XmlNSDescriptor nsDescriptor = this.NSDescriptor;
        if (nsDescriptor == null || !this.NSDescriptor.getDeclaration().isValid()) {
            XmlFile file = XmlUtil.getContainingFile(this.getDeclaration());
            if (file == null) {
                return null;
            }
            XmlDocument document = file.getDocument();
            if (document == null) {
                return null;
            }
            this.NSDescriptor = nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        }
        return nsDescriptor;
    }

    @Override
    public XmlElementsGroup getTopGroup() {
        TypeDescriptor type = this.getType();
        return type instanceof ComplexTypeDescriptor ? ((ComplexTypeDescriptor)type).getTopGroup() : null;
    }

    @Nullable
    public TypeDescriptor getType() {
        return this.getType(null);
    }

    @Nullable
    public TypeDescriptor getType(XmlElement context) {
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor(context);
        if (!(nsDescriptor instanceof XmlNSTypeDescriptorProvider)) {
            return null;
        }
        TypeDescriptor type = ((XmlNSTypeDescriptorProvider)((Object)nsDescriptor)).getTypeDescriptor(this.myDescriptorTag);
        if (type == null) {
            String substAttr = this.myDescriptorTag.getAttributeValue("substitutionGroup");
            if (substAttr != null) {
                String namespacePrefix = XmlUtil.findPrefixByQualifiedName(substAttr);
                String namespace = namespacePrefix.isEmpty() ? this.getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
                String local = XmlUtil.findLocalNameByQualifiedName(substAttr);
                XmlElementDescriptorImpl originalElement = (XmlElementDescriptorImpl)((XmlNSDescriptorImpl)this.getNSDescriptor()).getElementDescriptor(local, namespace);
                if (originalElement != null && originalElement != this) {
                    type = originalElement.getType(context);
                }
            }
        } else if (context instanceof XmlTag) {
            TypeDescriptor typeDescriptor;
            XmlNSDescriptor descriptor;
            XmlTag tag = (XmlTag)context;
            if (nsDescriptor instanceof XmlNSDescriptorImpl && !tag.getNamespace().equals(((XmlNSDescriptorImpl)nsDescriptor).getDefaultNamespace()) && (descriptor = tag.getNSDescriptor(tag.getNamespace(), true)) != nsDescriptor && descriptor instanceof XmlNSTypeDescriptorProvider && (typeDescriptor = ((XmlNSTypeDescriptorProvider)((Object)descriptor)).getTypeDescriptor(this.myDescriptorTag)) != null && typeDescriptor.getDeclaration() != type.getDeclaration()) {
                return typeDescriptor;
            }
        }
        return type;
    }

    @Override
    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlElementDescriptor parentDescriptorByType;
        if (context != null && (parentDescriptorByType = XmlUtil.findXmlDescriptorByType(context)) != null && !parentDescriptorByType.equals(this)) {
            return parentDescriptorByType.getElementsDescriptors(context);
        }
        Object[] elementsDescriptors = this.getElementsDescriptorsImpl(context);
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor) {
            PsiFile containingFile;
            ComplexTypeDescriptor descriptor = (ComplexTypeDescriptor)type;
            PsiFile psiFile = containingFile = context != null ? context.getContainingFile() : null;
            if (context != null && !containingFile.isPhysical()) {
                containingFile = containingFile.getOriginalFile();
            }
            if (context != null) {
                XmlNSDescriptor nsDescriptor;
                String contextNs = context.getNamespace();
                if (descriptor.canContainTag(context.getLocalName(), contextNs, context) && (!contextNs.equals(this.getNamespace()) || descriptor.hasAnyInContentModel()) && containingFile instanceof XmlFile && (nsDescriptor = this.getNSDescriptor()) != null) {
                    elementsDescriptors = (XmlElementDescriptor[])ArrayUtil.mergeArrays((Object[])elementsDescriptors, (Object[])nsDescriptor.getRootElementsDescriptors(((XmlFile)containingFile).getDocument()));
                }
            }
        }
        return elementsDescriptors;
    }

    private XmlElementDescriptor[] getElementsDescriptorsImpl(XmlElement context) {
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor) {
            String[] namespaces;
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            XmlElementDescriptor[] elements = typeDescriptor.getElements(context);
            if (context instanceof XmlTag && elements.length > 0 && (namespaces = ((XmlTag)context).knownNamespaces()).length > 1) {
                ArrayList<XmlElementDescriptor> result2 = new ArrayList<XmlElementDescriptor>(Arrays.asList(elements));
                for (String namespace : namespaces) {
                    XmlNSDescriptor descriptor;
                    if (namespace.equals(typeDescriptor.getNsDescriptor().getDefaultNamespace()) || !((descriptor = ((XmlTag)context).getNSDescriptor(namespace, false)) instanceof XmlNSDescriptorImpl) || !((XmlNSDescriptorImpl)descriptor).hasSubstitutions()) continue;
                    for (XmlElementDescriptor element : elements) {
                        String name = XmlUtil.getLocalName(element.getName(context)).toString();
                        String s = ((XmlNSDescriptorImpl)element.getNSDescriptor()).getDefaultNamespace();
                        XmlElementDescriptor[] substitutes = ((XmlNSDescriptorImpl)descriptor).getSubstitutes(name, s);
                        result2.addAll(Arrays.asList(substitutes));
                    }
                }
                return result2.toArray(XmlElementDescriptor.EMPTY_ARRAY);
            }
            return elements;
        }
        return EMPTY_ARRAY;
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor) {
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            XmlAttributeDescriptor[] attributeDescriptors = typeDescriptor.getAttributes(context);
            if (context != null) {
                String contextNs = context.getNamespace();
                boolean seenXmlNs = false;
                for (String ns : context.knownNamespaces()) {
                    if (contextNs.equals(ns) || ns.isEmpty()) continue;
                    seenXmlNs |= "http://www.w3.org/XML/1998/namespace".equals(ns);
                    attributeDescriptors = XmlElementDescriptorImpl.updateAttributeDescriptorsFromAny(context, typeDescriptor, attributeDescriptors, ns);
                }
                if (!seenXmlNs) {
                    attributeDescriptors = XmlElementDescriptorImpl.updateAttributeDescriptorsFromAny(context, typeDescriptor, attributeDescriptors, "http://www.w3.org/XML/1998/namespace");
                }
            }
            return attributeDescriptors;
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    private static XmlAttributeDescriptor[] updateAttributeDescriptorsFromAny(XmlTag context, ComplexTypeDescriptor typeDescriptor, XmlAttributeDescriptor[] attributeDescriptors, String ns) {
        XmlNSDescriptor descriptor;
        if (typeDescriptor.canContainAttribute(ns, null) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain && (descriptor = context.getNSDescriptor(ns, true)) instanceof XmlNSDescriptorImpl) {
            Object[] rootDescriptors = ((XmlNSDescriptorImpl)descriptor).getRootAttributeDescriptors(context);
            attributeDescriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])attributeDescriptors, (Object[])rootDescriptors);
        }
        return attributeDescriptors;
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        return this.getAttributeDescriptorImpl(attributeName, context);
    }

    @Nullable
    private XmlAttributeDescriptor getAttributeDescriptorImpl(String attributeName, XmlTag context) {
        XmlNSDescriptor candidateNSDescriptor;
        ComplexTypeDescriptor.CanContainAttributeType containAttributeType;
        String namespacePrefix;
        String namespace;
        String localName = XmlUtil.findLocalNameByQualifiedName(attributeName);
        XmlAttributeDescriptor attribute = this.getAttribute(localName, namespace = (namespacePrefix = XmlUtil.findPrefixByQualifiedName(attributeName)).isEmpty() ? this.getDefaultNamespace() : context.getNamespaceByPrefix(namespacePrefix), context, attributeName);
        if (attribute instanceof AnyXmlAttributeDescriptor && (containAttributeType = ((AnyXmlAttributeDescriptor)attribute).getCanContainAttributeType()) != ComplexTypeDescriptor.CanContainAttributeType.CanContainAny && !namespace.isEmpty() && (candidateNSDescriptor = context.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl) {
            XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)candidateNSDescriptor;
            XmlAttributeDescriptor xmlAttributeDescriptor = nsDescriptor.getAttribute(localName, namespace, context);
            if (xmlAttributeDescriptor != null) {
                return xmlAttributeDescriptor;
            }
            if (containAttributeType == ComplexTypeDescriptor.CanContainAttributeType.CanContainButDoNotSkip) {
                attribute = null;
            }
        }
        return attribute;
    }

    private String getDefaultNamespace() {
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        return nsDescriptor instanceof XmlNSDescriptorImpl ? ((XmlNSDescriptorImpl)nsDescriptor).getDefaultNamespace() : "";
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptorImpl(attribute.getName(), attribute.getParent());
    }

    @Nullable
    private XmlAttributeDescriptor getAttribute(String attributeName, String namespace, XmlTag context, String qName) {
        ComplexTypeDescriptor descriptor;
        ComplexTypeDescriptor.CanContainAttributeType containAttributeType;
        XmlAttributeDescriptor[] descriptors;
        for (XmlAttributeDescriptor descriptor2 : descriptors = this.getAttributesDescriptors(context)) {
            if (!descriptor2.getName().equals(attributeName) || !descriptor2.getName(context).equals(qName)) continue;
            return descriptor2;
        }
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor && (containAttributeType = (descriptor = (ComplexTypeDescriptor)type).canContainAttribute(namespace, qName)) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain) {
            return new AnyXmlAttributeDescriptor(attributeName, containAttributeType);
        }
        return null;
    }

    @Override
    public int getContentType() {
        TypeDescriptor type = this.getType();
        if (type instanceof ComplexTypeDescriptor) {
            return ((ComplexTypeDescriptor)type).getContentType();
        }
        return 3;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(String name) {
        String localName = XmlUtil.findLocalNameByQualifiedName(name);
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(name);
        String namespace = namespacePrefix.isEmpty() ? this.getDefaultNamespace() : this.myDescriptorTag.getNamespaceByPrefix(namespacePrefix);
        return this.getElementDescriptor(localName, namespace, null, name);
    }

    @Nullable
    protected XmlElementDescriptor getElementDescriptor(String localName, String namespace, XmlElement context, String fullName) {
        ComplexTypeDescriptor descriptor;
        XmlElementDescriptor[] elements;
        for (XmlElementDescriptor element1 : elements = this.getElementsDescriptorsImpl(context)) {
            XmlNSDescriptor descriptor2;
            XmlElementDescriptorImpl element = (XmlElementDescriptorImpl)element1;
            String namespaceByContext = element.getNamespaceByContext(context);
            if (!StringUtil.equals((CharSequence)element.getName(), (CharSequence)localName)) continue;
            if (namespace == null || namespace.equals(namespaceByContext) || namespaceByContext.equals("") || element.getName(context).equals(fullName) || namespace.isEmpty() && element.getDefaultName().equals(fullName)) {
                return element;
            }
            XmlNSDescriptor xmlNSDescriptor = descriptor2 = context instanceof XmlTag ? ((XmlTag)context).getNSDescriptor(namespace, true) : null;
            if (!(descriptor2 instanceof XmlNSDescriptorImpl)) continue;
            if (((XmlNSDescriptorImpl)descriptor2).getDefaultNamespace().equals(namespaceByContext)) {
                return element;
            }
            ((XmlNSDescriptorImpl)descriptor2).getSubstitutes(localName, namespace);
        }
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor && (descriptor = (ComplexTypeDescriptor)type).canContainTag(localName, namespace, context)) {
            return new AnyXmlElementDescriptor(this, this.getNSDescriptor());
        }
        return null;
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(XmlTag element, XmlTag contextTag) {
        XmlElement context = (XmlElement)element.getParent();
        XmlElementDescriptor elementDescriptor = this.getElementDescriptor(element.getLocalName(), element.getNamespace(), context, element.getName());
        if (elementDescriptor == null || element.getAttributeValue("xsi:type") != null) {
            XmlElementDescriptor parentXmlDescriptorByType;
            XmlElementDescriptor xmlDescriptorByType = XmlUtil.findXmlDescriptorByType(element);
            if (xmlDescriptorByType != null) {
                elementDescriptor = xmlDescriptorByType;
            } else if (context instanceof XmlTag && ((XmlTag)context).getAttributeValue("xsi:type") != null && this.askParentDescriptorViaXsi() && (parentXmlDescriptorByType = XmlUtil.findXmlDescriptorByType((XmlTag)context)) != null) {
                elementDescriptor = parentXmlDescriptorByType.getElementDescriptor(element, contextTag);
            }
        }
        return elementDescriptor;
    }

    protected boolean askParentDescriptorViaXsi() {
        return true;
    }

    @Override
    public String getQualifiedName() {
        String ns = this.getNS();
        if (ns != null && !ns.isEmpty()) {
            return ns + ":" + this.getName();
        }
        return this.getName();
    }

    @Nullable
    private String getNS() {
        return XmlUtil.findNamespacePrefixByURI((XmlFile)this.myDescriptorTag.getContainingFile(), this.getNamespace());
    }

    @Override
    public String getDefaultName() {
        return this.isQualifiedForm() ? this.getQualifiedName() : this.getName();
    }

    private boolean isQualifiedForm() {
        String value = this.myDescriptorTag.getAttributeValue("form");
        if (value == null) {
            XmlTag rootTag;
            PsiFile psiFile = this.myDescriptorTag.getContainingFile();
            XmlTag xmlTag = rootTag = psiFile instanceof XmlFile ? ((XmlFile)psiFile).getRootTag() : null;
            if (rootTag != null) {
                value = rootTag.getAttributeValue(ELEMENT_FORM_DEFAULT);
            }
        }
        return QUALIFIED_ATTR_VALUE.equals(value);
    }

    public boolean isAbstract() {
        return XmlElementDescriptorImpl.isAbstractDeclaration(this.myDescriptorTag);
    }

    public static Boolean isAbstractDeclaration(XmlTag descriptorTag) {
        return Boolean.valueOf(descriptorTag.getAttributeValue("abstract"));
    }

    public void setName(String name) throws IncorrectOperationException {
        NamedObjectDescriptor.setName(this.myDescriptorTag, name);
    }

    public void setValidator(Validator<XmlTag> validator) {
        this.myValidator = validator;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        Validator<XmlTag> validator;
        if (context == null) {
            XmlElementDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (host == null) {
            XmlElementDescriptorImpl.$$$reportNull$$$0(2);
        }
        if ((validator = this.myValidator) != null) {
            validator.validate((PsiElement)context, host);
        }
    }

    @Override
    public PsiReference[] getValueReferences(XmlTag xmlTag, @NotNull String text2) {
        XmlTagValue value;
        XmlText[] elements;
        if (text2 == null) {
            XmlElementDescriptorImpl.$$$reportNull$$$0(3);
        }
        if ((elements = (value = xmlTag.getValue()).getTextElements()).length == 0 || xmlTag.getSubTags().length > 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new XmlEnumeratedReferenceSet(xmlTag, this).getPsiReferences();
    }

    @Override
    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        TypeDescriptor type = this.getType(context);
        if (type instanceof ComplexTypeDescriptor) {
            ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
            return typeDescriptor.canContainTag("a", namespace, context) || typeDescriptor.getNsDescriptor().hasSubstitutions() || XmlUtil.nsFromTemplateFramework(namespace);
        }
        return false;
    }

    public String toString() {
        String namespace;
        try {
            namespace = this.getNamespace();
        }
        catch (PsiInvalidElementAccessException e) {
            namespace = "!!!Invalid!!!";
        }
        return this.getName() + " (" + namespace + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlElementDescriptorImpl that = (XmlElementDescriptorImpl)o;
        return !(this.myDescriptorTag != null ? !this.myDescriptorTag.equals(that.myDescriptorTag) : that.myDescriptorTag != null);
    }

    public int hashCode() {
        return this.myDescriptorTag != null ? this.myDescriptorTag.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/impl/schema/XmlElementDescriptorImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/impl/schema/XmlElementDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueReferences";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

