/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.XmlElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValuePattern
extends XmlElementPattern<XmlAttributeValue, XmlAttributeValuePattern> {
    static final XmlAttributeValuePattern XML_ATTRIBUTE_VALUE_PATTERN = new XmlAttributeValuePattern(new InitialPatternCondition<XmlAttributeValue>(XmlAttributeValue.class){

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof XmlAttributeValue;
        }
    });

    public XmlAttributeValuePattern(InitialPatternCondition<XmlAttributeValue> condition) {
        super(condition);
    }

    public XmlAttributeValuePattern withLocalName(String ... names) {
        return names.length == 1 ? this.withLocalName((ElementPattern<String>)StandardPatterns.string().equalTo((Object)names[0])) : this.withLocalName((ElementPattern<String>)StandardPatterns.string().oneOf(names));
    }

    public XmlAttributeValuePattern withLocalNameIgnoreCase(String ... names) {
        return this.withLocalName((ElementPattern<String>)StandardPatterns.string().oneOfIgnoreCase(names));
    }

    public XmlAttributeValuePattern withLocalName(ElementPattern<String> namePattern) {
        return (XmlAttributeValuePattern)this.with((PatternCondition)new PsiNamePatternCondition<XmlAttributeValue>("withLocalName", namePattern){

            public String getPropertyValue(@NotNull Object o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (o instanceof XmlAttributeValue) {
                    return XmlAttributeValuePattern.getLocalName((XmlAttributeValue)o);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/XmlAttributeValuePattern$2", "getPropertyValue"));
            }
        });
    }

    public XmlAttributeValuePattern withNamespace(ElementPattern<String> namePattern) {
        return (XmlAttributeValuePattern)this.with((PatternCondition)new PsiNamePatternCondition<XmlAttributeValue>("withNamespace", namePattern){

            public String getPropertyValue(@NotNull Object o) {
                PsiElement parent;
                if (o == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (o instanceof XmlAttributeValue && (parent = ((XmlAttributeValue)o).getParent()) instanceof XmlAttribute) {
                    return ((XmlAttribute)parent).getNamespace();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/XmlAttributeValuePattern$3", "getPropertyValue"));
            }
        });
    }

    public XmlAttributeValuePattern withNamespace(String ... names) {
        return names.length == 1 ? this.withNamespace((ElementPattern<String>)StandardPatterns.string().equalTo((Object)names[0])) : this.withNamespace((ElementPattern<String>)StandardPatterns.string().oneOf(names));
    }

    @Nullable
    public static String getLocalName(@NotNull XmlAttributeValue value) {
        PsiElement parent;
        if (value == null) {
            XmlAttributeValuePattern.$$$reportNull$$$0(0);
        }
        if ((parent = value.getParent()) instanceof XmlAttribute) {
            return ((XmlAttribute)parent).getLocalName();
        }
        if (parent instanceof XmlProcessingInstruction) {
            PsiElement prev = value.getPrevSibling();
            if (!(prev instanceof XmlToken) || ((XmlToken)prev).getTokenType() != XmlTokenType.XML_EQ) {
                return null;
            }
            if (!((prev = prev.getPrevSibling()) instanceof XmlToken) || ((XmlToken)prev).getTokenType() != XmlTokenType.XML_NAME) {
                return null;
            }
            return prev.getText();
        }
        return null;
    }

    public XmlAttributeValuePattern withValue(final StringPattern valuePattern) {
        return (XmlAttributeValuePattern)this.with((PatternCondition)new PatternCondition<XmlAttributeValue>("withValue"){

            public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
                if (xmlAttributeValue == null) {
                    4.$$$reportNull$$$0(0);
                }
                return valuePattern.accepts((Object)xmlAttributeValue.getValue(), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/patterns/XmlAttributeValuePattern$4", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/patterns/XmlAttributeValuePattern", "getLocalName"));
    }
}

