/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.HtmlUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/browsers/WebBrowserXmlServiceImpl;", "Lcom/intellij/ide/browsers/WebBrowserXmlService;", "<init>", "()V", "isHtmlFile", "", "element", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isHtmlOrXmlFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "isXmlLanguage", "language", "Lcom/intellij/lang/Language;", "isHtmlOrXmlLanguage", "intellij.xml.impl"})
final class WebBrowserXmlServiceImpl
extends WebBrowserXmlService {
    public boolean isHtmlFile(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return HtmlUtil.isHtmlFile(element);
    }

    public boolean isHtmlFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return HtmlUtil.isHtmlFile(file);
    }

    public boolean isHtmlOrXmlFile(@NotNull PsiFile psiFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (!this.isHtmlFile(virtualFile) && !FileTypeRegistry.getInstance().isFileOfType(psiFile.getVirtualFile(), (FileType)XmlFileType.INSTANCE)) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getBaseLanguage(...)");
        Language baseLanguage = language;
        if (this.isHtmlOrXmlLanguage(baseLanguage)) {
            return true;
        }
        if (psiFile.getFileType() instanceof LanguageFileType) {
            FileType fileType = psiFile.getFileType();
            Intrinsics.checkNotNull((Object)fileType, (String)"null cannot be cast to non-null type com.intellij.openapi.fileTypes.LanguageFileType");
            Language language2 = ((LanguageFileType)fileType).getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
            bl = this.isHtmlOrXmlLanguage(language2);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isXmlLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE);
    }

    public boolean isHtmlOrXmlLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language.isKindOf((Language)HTMLLanguage.INSTANCE) || language == XHTMLLanguage.INSTANCE || language == XMLLanguage.INSTANCE;
    }
}

