/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddHtmlTagOrAttributeToCustomsIntention;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.html.impl.providers.HtmlAttributeValueProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.JBIterable;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RequiredAttributesInspectionBase
extends HtmlLocalInspectionTool
implements XmlEntitiesInspection {
    @NonNls
    public static final Key<InspectionProfileEntry> SHORT_NAME_KEY = Key.create((String)"RequiredAttributes");
    protected static final Logger LOG = Logger.getInstance(RequiredAttributesInspectionBase.class);
    @NlsSafe
    public String myAdditionalRequiredHtmlAttributes = "";

    private static String appendName(String toAppend, String text2) {
        toAppend = !((String)toAppend).isEmpty() ? (String)toAppend + "," + text2 : text2;
        return toAppend;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "RequiredAttributes";
    }

    @Override
    public String getAdditionalEntries() {
        return this.myAdditionalRequiredHtmlAttributes;
    }

    @Override
    public void addEntry(String text2) {
        this.myAdditionalRequiredHtmlAttributes = RequiredAttributesInspectionBase.appendName(this.getAdditionalEntries(), text2);
    }

    @NotNull
    public static LocalQuickFix getIntentionAction(String name) {
        return new AddHtmlTagOrAttributeToCustomsIntention(SHORT_NAME_KEY, name, XmlAnalysisBundle.message("html.quickfix.add.optional.html.attribute", name));
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(1);
        }
        String name = tag.getName();
        XmlElementDescriptor elementDescriptor = XmlUtil.getDescriptorFromContext(tag);
        if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
            elementDescriptor = tag.getDescriptor();
        }
        if (elementDescriptor == null) {
            return;
        }
        if (elementDescriptor instanceof XmlHighlightingAwareElementDescriptor && !((XmlHighlightingAwareElementDescriptor)((Object)elementDescriptor)).shouldCheckRequiredAttributes()) {
            return;
        }
        XmlAttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributesDescriptors(tag);
        HashSet<String> requiredAttributes = null;
        for (XmlAttributeDescriptor attribute : attributeDescriptors) {
            if (attribute == null || !attribute.isRequired()) continue;
            if (requiredAttributes == null) {
                requiredAttributes = new HashSet<String>();
            }
            requiredAttributes.add(attribute.getName(tag));
        }
        if (requiredAttributes != null) {
            for (String attrName : requiredAttributes) {
                if (RequiredAttributesInspectionBase.hasAttribute(tag, attrName) || XmlExtension.getExtension(tag.getContainingFile()).isRequiredAttributeImplicitlyPresent(tag, attrName)) continue;
                LocalQuickFixAndIntentionActionOnPsiElement insertRequiredAttributeIntention = isOnTheFly ? XmlQuickFixFactory.getInstance().insertRequiredAttributeFix(tag, attrName, new String[0]) : null;
                String localizedMessage = XmlAnalysisBundle.message("xml.inspections.element.doesnt.have.required.attribute", name, attrName);
                this.reportOneTagProblem(tag, attrName, localizedMessage, (LocalQuickFix)insertRequiredAttributeIntention, holder, RequiredAttributesInspectionBase.getIntentionAction(attrName), isOnTheFly);
            }
        }
    }

    private static boolean hasAttribute(XmlTag tag, String attrName) {
        if (JBIterable.from((Iterable)HtmlAttributeValueProvider.EP_NAME.getExtensionList()).filterMap(it -> it.getCustomAttributeValue(tag, attrName)).first() != null) {
            return true;
        }
        XmlAttribute attribute = tag.getAttribute(attrName);
        if (attribute == null) {
            return false;
        }
        if (attribute.getValueElement() != null) {
            return true;
        }
        if (!(tag instanceof HtmlTag)) {
            return false;
        }
        XmlAttributeDescriptor descriptor = attribute.getDescriptor();
        return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, tag);
    }

    private void reportOneTagProblem(XmlTag tag, String name, @NotNull @InspectionMessage String localizedMessage, LocalQuickFix basicIntention, ProblemsHolder holder, @NotNull LocalQuickFix addAttributeFix, boolean isOnTheFly) {
        ProblemHighlightType highlightType;
        LocalQuickFix[] fixes;
        if (localizedMessage == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(2);
        }
        if (addAttributeFix == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(3);
        }
        boolean htmlTag = false;
        if (tag instanceof HtmlTag) {
            htmlTag = true;
            if (RequiredAttributesInspectionBase.isAdditionallyDeclared(this.getAdditionalEntries(), name)) {
                return;
            }
        }
        if (htmlTag) {
            LocalQuickFix[] localQuickFixArray;
            if (basicIntention == null) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = addAttributeFix;
            } else {
                LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
                localQuickFixArray3[0] = addAttributeFix;
                localQuickFixArray = localQuickFixArray3;
                localQuickFixArray3[1] = basicIntention;
            }
            fixes = localQuickFixArray;
            highlightType = XmlHighlightVisitor.isInjectedWithoutValidation(tag) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        } else {
            LocalQuickFix[] localQuickFixArray;
            if (basicIntention == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray4;
                localQuickFixArray4[0] = basicIntention;
            }
            fixes = localQuickFixArray;
            highlightType = ProblemHighlightType.ERROR;
        }
        if (isOnTheFly || highlightType != ProblemHighlightType.INFORMATION) {
            RequiredAttributesInspectionBase.addElementsForTag(tag, localizedMessage, highlightType, holder, isOnTheFly, fixes);
        }
    }

    private static void addElementsForTag(XmlTag tag, @InspectionMessage String message, ProblemHighlightType error, ProblemsHolder holder, boolean isOnTheFly, LocalQuickFix ... fixes) {
        if (fixes == null) {
            RequiredAttributesInspectionBase.$$$reportNull$$$0(4);
        }
        RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getStartTagNameElement(tag), fixes);
        if (isOnTheFly) {
            RequiredAttributesInspectionBase.registerProblem(message, error, holder, XmlTagUtil.getEndTagNameElement(tag), fixes);
        }
    }

    private static void registerProblem(@InspectionMessage String message, ProblemHighlightType error, ProblemsHolder holder, XmlToken start2, LocalQuickFix[] fixes) {
        if (start2 != null) {
            holder.registerProblem((PsiElement)start2, message, error, fixes);
        }
    }

    private static boolean isAdditionallyDeclared(String additional, String name) {
        if (!additional.contains(name = StringUtil.toLowerCase((String)name))) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(additional, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!name.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addAttributeFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/htmlInspections/RequiredAttributesInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTag";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportOneTagProblem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addElementsForTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

