/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerationNode
extends UserDataHolderBase {
    private final TemplateToken myTemplateToken;
    private final List<GenerationNode> myChildren = new ArrayList<GenerationNode>();
    private final int myNumberInIteration;
    private final int myTotalIterations;
    private String mySurroundedText;
    private final boolean myInsertSurroundedTextAtTheEnd;
    private final boolean myInsertNewLineBetweenNodes;
    private GenerationNode myParent;
    private boolean myContainsSurroundedTextMarker = false;
    private static final Pattern ATTRIBUTE_VARIABLE_PATTERN = Pattern.compile("\\$[A-z_0-9]+\\$");
    private static final Pattern HREF_PATTERN = Pattern.compile("^(?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$])", 2);
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,5}$");
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^([A-z]+:)?//");

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        this(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent, false);
    }

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent, boolean insertNewLineBetweenNodes) {
        this.myTemplateToken = templateToken;
        this.myNumberInIteration = numberInIteration;
        this.myTotalIterations = totalIterations;
        this.mySurroundedText = surroundedText;
        this.myInsertSurroundedTextAtTheEnd = insertSurroundedTextAtTheEnd;
        this.myInsertNewLineBetweenNodes = insertNewLineBetweenNodes;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isInsertNewLineBetweenNodes() {
        return this.myInsertNewLineBetweenNodes;
    }

    public List<GenerationNode> getChildren() {
        return this.myChildren;
    }

    public void addChild(GenerationNode child) {
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void addChildren(Collection<? extends GenerationNode> children) {
        for (GenerationNode generationNode : children) {
            this.addChild(generationNode);
        }
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    private boolean isBlockTag() {
        XmlTag tag;
        if (this.myTemplateToken != null && (tag = this.myTemplateToken.getXmlTag()) != null) {
            return HtmlUtil.isHtmlBlockTag(tag.getName(), true);
        }
        return false;
    }

    @NotNull
    public TemplateImpl generate(@NotNull CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator, @NotNull Collection<ZenCodingFilter> filters, boolean insertSurroundedText, int segmentsLimit) {
        Map<String, String> predefinedValues;
        TemplateImpl parentTemplate;
        boolean hasChildren;
        String indentStr;
        if (callback == null) {
            GenerationNode.$$$reportNull$$$0(0);
        }
        if (filters == null) {
            GenerationNode.$$$reportNull$$$0(1);
        }
        this.myContainsSurroundedTextMarker = !insertSurroundedText || !this.myInsertSurroundedTextAtTheEnd;
        GenerationNode generationNode = this;
        boolean shouldNotReformatTemplate = false;
        boolean oneLineTemplateExpanding = false;
        for (ZenCodingFilter filter2 : filters) {
            generationNode = filter2.filterNode(generationNode);
            if (!(filter2 instanceof SingleLineEmmetFilter)) continue;
            shouldNotReformatTemplate = true;
            oneLineTemplateExpanding = true;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)callback.getFile());
        if (callback.isInInjectedFragment()) {
            Editor editor = callback.getEditor();
            Document document = editor.getDocument();
            if (document instanceof DocumentWindow && ((DocumentWindow)document).isOneLine()) {
                oneLineTemplateExpanding = true;
                filters.add(new SingleLineEmmetFilter());
            }
            indentStr = "";
        } else if (settings.useTabCharacter(callback.getFileType())) {
            indentStr = "\t";
        } else {
            int tabSize = settings.getTabSize(callback.getFileType());
            indentStr = StringUtil.repeatSymbol((char)' ', (int)tabSize);
        }
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        int end = -1;
        boolean bl = hasChildren = this.myChildren.size() > 0;
        if (generator instanceof XmlZenCodingGenerator) {
            TemplateToken xmlTemplateToken = this.myTemplateToken;
            parentTemplate = this.invokeXmlTemplate(xmlTemplateToken, callback, generator, hasChildren);
            predefinedValues = this.buildPredefinedValues(xmlTemplateToken.getAttributes(), (XmlZenCodingGenerator)generator, hasChildren);
        } else {
            parentTemplate = GenerationNode.invokeTemplate(this.myTemplateToken, hasChildren, callback, generator);
            predefinedValues = null;
        }
        String s = parentTemplate.getString();
        for (ZenCodingFilter filter3 : filters) {
            s = filter3.filterText(s, this.myTemplateToken);
        }
        parentTemplate = parentTemplate.copy();
        parentTemplate.setString(s);
        String txt = hasChildren || this.myContainsSurroundedTextMarker ? null : this.mySurroundedText;
        parentTemplate = GenerationNode.expandTemplate(parentTemplate, predefinedValues, txt, segmentsLimit);
        int offset = builder2.insertTemplate(0, parentTemplate, null);
        int newOffset = GenerationNode.gotoChild(callback.getProject(), builder2.getText(), offset, 0, builder2.length());
        if (offset < builder2.length() && newOffset != offset) {
            end = offset;
        }
        offset = newOffset;
        if (end == -1 && offset < builder2.length() && this.myChildren.size() == 0) {
            end = offset;
        }
        LiveTemplateBuilder.Marker marker = offset < builder2.length() ? builder2.createMarker(offset) : null;
        int myChildrenSize = this.myChildren.size();
        for (int i = 0; i < myChildrenSize; ++i) {
            GenerationNode child = this.myChildren.get(i);
            TemplateImpl childTemplate = child.generate(callback, generator, filters, !this.myContainsSurroundedTextMarker, segmentsLimit);
            boolean blockTag = child.isBlockTag();
            if (!oneLineTemplateExpanding && blockTag && !GenerationNode.isNewLineBefore(builder2.getText(), offset)) {
                builder2.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            int e = builder2.insertTemplate(offset, childTemplate, null);
            int n = offset = marker != null ? marker.getEndOffset() : builder2.length();
            if (!oneLineTemplateExpanding && (blockTag && !GenerationNode.isNewLineAfter(builder2.getText(), offset) || this.myInsertNewLineBetweenNodes)) {
                builder2.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            if (end != -1 || e >= offset) continue;
            end = e;
        }
        if (shouldNotReformatTemplate) {
            builder2.setIsToReformat(false);
        }
        TemplateImpl templateImpl = builder2.buildTemplate();
        if (templateImpl == null) {
            GenerationNode.$$$reportNull$$$0(2);
        }
        return templateImpl;
    }

    private static TemplateImpl invokeTemplate(@NotNull TemplateToken token, boolean hasChildren, CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator) {
        if (token == null) {
            GenerationNode.$$$reportNull$$$0(3);
        }
        TemplateImpl template = token.getTemplate();
        if (generator != null) {
            assert (template != null);
            template = generator.generateTemplate(token, hasChildren, callback.getContext());
            GenerationNode.removeVariablesWhichHasNoSegment(template);
        }
        return template;
    }

    private TemplateImpl invokeXmlTemplate(TemplateToken token, CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator, boolean hasChildren) {
        ZenCodingGenerator zenCodingGenerator = (ZenCodingGenerator)ObjectUtils.notNull((Object)generator, (Object)XmlZenCodingGeneratorImpl.INSTANCE);
        Map<String, String> attributes = token.getAttributes();
        TemplateImpl template = token.getTemplate();
        assert (template != null);
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)callback.getProject());
        PsiFile dummyFile = fileFactory.createFileFromText("dummy.html", callback.getFile().getLanguage(), (CharSequence)token.getTemplateText(), false, true);
        XmlTag tag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)dummyFile, XmlTag.class);
        if (tag != null) {
            if (EmmetOptions.getInstance().isHrefAutoDetectEnabled() && StringUtil.isNotEmpty((String)this.mySurroundedText)) {
                boolean isEmptyLinkTag;
                boolean bl = isEmptyLinkTag = "a".equalsIgnoreCase(tag.getName()) && GenerationNode.isEmptyValue(tag.getAttributeValue("href"));
                if (!hasChildren && isEmptyLinkTag) {
                    if (HREF_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes.put("href", (String)(PROTOCOL_PATTERN.matcher(this.mySurroundedText).find() ? this.mySurroundedText.trim() : "http://" + this.mySurroundedText.trim()));
                    } else if (EMAIL_PATTERN.matcher(this.mySurroundedText).matches()) {
                        attributes.put("href", "mailto:" + this.mySurroundedText.trim());
                    }
                }
            }
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                if (!Strings.isEmpty((String)attribute.getValue())) continue;
                template.addVariable(GenerationNode.prepareVariableName(attribute.getKey()), "", "", true);
            }
            XmlTag tag1 = hasChildren ? GenerationNode.expandEmptyTagIfNecessary(tag) : tag;
            this.setAttributeValues(tag1, attributes, callback, zenCodingGenerator.isHtml(callback));
            token.setTemplateText(tag1.getContainingFile().getText(), callback.getFile());
        }
        template = zenCodingGenerator.generateTemplate(token, hasChildren, callback.getContext());
        GenerationNode.removeVariablesWhichHasNoSegment(template);
        return template;
    }

    private static String prepareVariableName(@NotNull String attributeName) {
        if (attributeName == null) {
            GenerationNode.$$$reportNull$$$0(4);
        }
        char[] toReplace = new char[]{'$', '-', '+', ':'};
        StringBuilder builder2 = new StringBuilder(attributeName.length());
        for (int i = 0; i < attributeName.length(); ++i) {
            char c = attributeName.charAt(i);
            boolean replaced = false;
            for (char aToReplace : toReplace) {
                if (c != aToReplace) continue;
                builder2.append('_');
                replaced = true;
                break;
            }
            if (replaced) continue;
            builder2.append(c);
        }
        return builder2.toString();
    }

    @NotNull
    private static TemplateImpl expandTemplate(@NotNull TemplateImpl template, Map<String, String> predefinedVarValues, String surroundedText, int segmentsLimit) {
        if (template == null) {
            GenerationNode.$$$reportNull$$$0(5);
        }
        LiveTemplateBuilder builder2 = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        if (predefinedVarValues == null && surroundedText == null) {
            TemplateImpl templateImpl = template;
            if (templateImpl == null) {
                GenerationNode.$$$reportNull$$$0(6);
            }
            return templateImpl;
        }
        int offset = builder2.insertTemplate(0, template, predefinedVarValues);
        if (surroundedText != null) {
            builder2.insertText(offset, surroundedText, true);
            builder2.setIsToReformat(true);
        }
        TemplateImpl templateImpl = builder2.buildTemplate();
        if (templateImpl == null) {
            GenerationNode.$$$reportNull$$$0(7);
        }
        return templateImpl;
    }

    @NotNull
    private static XmlTag expandEmptyTagIfNecessary(@NotNull XmlTag tag) {
        if (tag == null) {
            GenerationNode.$$$reportNull$$$0(8);
        }
        StringBuilder builder2 = new StringBuilder();
        boolean flag = false;
        for (PsiElement child : tag.getChildren()) {
            if (child instanceof XmlToken && XmlTokenType.XML_EMPTY_ELEMENT_END.equals(((XmlToken)child).getTokenType())) {
                flag = true;
                break;
            }
            builder2.append(child.getText());
        }
        if (flag) {
            builder2.append("></").append(tag.getName()).append('>');
            XmlTag xmlTag = XmlElementFactory.getInstance(tag.getProject()).createTagFromText(builder2.toString(), (Language)XMLLanguage.INSTANCE);
            if (xmlTag == null) {
                GenerationNode.$$$reportNull$$$0(9);
            }
            return xmlTag;
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            GenerationNode.$$$reportNull$$$0(10);
        }
        return xmlTag;
    }

    private static int gotoChild(Project project2, CharSequence text2, int offset, int start2, int end) {
        PsiFile file = PsiFileFactory.getInstance((Project)project2).createFileFromText("dummy.xml", (FileType)XmlFileType.INSTANCE, text2, LocalTimeCounter.currentTime(), false);
        PsiElement element = file.findElementAt(offset);
        if (offset < end && element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_END_TAG_START) {
            return offset;
        }
        int newOffset = -1;
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)start2, (int)end, XmlTag.class);
        if (tag != null) {
            for (PsiElement child : tag.getChildren()) {
                if (!(child instanceof XmlToken) || ((XmlToken)child).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                newOffset = child.getTextOffset();
            }
        }
        if (newOffset >= 0) {
            return newOffset;
        }
        return offset;
    }

    private static void removeVariablesWhichHasNoSegment(TemplateImpl template) {
        int i;
        HashSet<String> segments = new HashSet<String>();
        for (i = 0; i < template.getSegmentsCount(); ++i) {
            segments.add(template.getSegmentName(i));
        }
        for (i = template.getVariableCount() - 1; i >= 0; --i) {
            String varName = template.getVariableNameAt(i);
            if (!segments.contains(varName)) {
                template.removeVariable(i);
                continue;
            }
            segments.remove(varName);
        }
    }

    @Nullable
    private Map<String, String> buildPredefinedValues(@NotNull Map<String, String> attributes, @Nullable XmlZenCodingGenerator generator, boolean hasChildren) {
        Object attributesString;
        if (attributes == null) {
            GenerationNode.$$$reportNull$$$0(11);
        }
        if (generator == null) {
            return Collections.emptyMap();
        }
        for (String value : attributes.values()) {
            if (!ZenCodingUtil.containsSurroundedTextMarker(value)) continue;
            this.myContainsSurroundedTextMarker = true;
            break;
        }
        attributesString = ((String)(attributesString = generator.buildAttributesString(attributes, hasChildren, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText))).length() > 0 ? " " + (String)attributesString : null;
        HashMap<String, Object> predefinedValues = null;
        if (attributesString != null) {
            predefinedValues = new HashMap<String, Object>();
            predefinedValues.put("ATTRS", attributesString);
        }
        return predefinedValues;
    }

    private void setAttributeValues(@NotNull XmlTag tag, @NotNull Map<String, String> attributes, @NotNull CustomTemplateCallback callback, boolean isHtml) {
        String defaultAttributeValue;
        if (tag == null) {
            GenerationNode.$$$reportNull$$$0(12);
        }
        if (attributes == null) {
            GenerationNode.$$$reportNull$$$0(13);
        }
        if (callback == null) {
            GenerationNode.$$$reportNull$$$0(14);
        }
        if ((defaultAttributeValue = attributes.get("%default")) != null) {
            String attributeName;
            attributes.remove("%default");
            List xmlAttributes = ContainerUtil.filter((Object[])tag.getAttributes(), attribute -> !attributes.containsKey(attribute.getLocalName()));
            XmlAttribute defaultAttribute = GenerationNode.findImpliedAttribute(xmlAttributes);
            if (defaultAttribute == null) {
                defaultAttribute = GenerationNode.findEmptyAttribute(xmlAttributes);
            }
            if (defaultAttribute != null && (attributeName = defaultAttribute.getName()).length() > 1) {
                String oldValue;
                if (GenerationNode.isImpliedAttribute(attributeName)) {
                    defaultAttribute = (XmlAttribute)defaultAttribute.setName(attributeName.substring(1));
                }
                if ((oldValue = defaultAttribute.getValue()) != null && StringUtil.containsChar((String)oldValue, (char)'|')) {
                    defaultAttribute.setValue(StringUtil.replace((String)oldValue, (String)"|", (String)defaultAttributeValue));
                } else {
                    defaultAttribute.setValue(defaultAttributeValue);
                }
            }
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String attributeName = xmlAttribute.getName();
            XmlAttributeValue xmlAttributeValueElement = xmlAttribute.getValueElement();
            if (xmlAttributeValueElement != null && !attributes.containsKey(attributeName) || GenerationNode.isImpliedAttribute(attributeName) || TemplateImplUtil.isValidVariable((String)attributeName)) continue;
            String attributeValue = StringUtil.notNullize((String)attributes.get(attributeName), (String)StringUtil.notNullize((String)xmlAttribute.getValue()));
            if (ZenCodingUtil.containsSurroundedTextMarker(attributeValue)) {
                this.myContainsSurroundedTextMarker = true;
            }
            if (isHtml && GenerationNode.isBooleanAttribute(attributeValue, xmlAttribute, callback)) {
                if (HtmlUtil.isShortNotationOfBooleanAttributePreferred()) {
                    PsiElement prevSibling;
                    if (xmlAttributeValueElement == null || (prevSibling = xmlAttributeValueElement.getPrevSibling()) == null || !prevSibling.textMatches((CharSequence)"=")) continue;
                    xmlAttribute.deleteChildRange(prevSibling, xmlAttributeValueElement);
                    continue;
                }
                if (xmlAttributeValueElement == null) {
                    xmlAttribute.delete();
                }
                tag.setAttribute(attributeName, attributeName);
                continue;
            }
            if (xmlAttributeValueElement == null) {
                xmlAttribute.delete();
            }
            tag.setAttribute(attributeName, (String)(StringUtil.isEmpty((String)attributeValue) ? "$" + GenerationNode.prepareVariableName(attributeName) + "$" : ZenCodingUtil.getValue(attributeValue, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText)));
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String xmlAttributeLocalName = xmlAttribute.getLocalName();
            if (xmlAttribute.getValue() == null || !GenerationNode.isImpliedAttribute(xmlAttributeLocalName)) continue;
            xmlAttribute.delete();
        }
    }

    private static boolean isBooleanAttribute(@Nullable String attributeValue, @NotNull XmlAttribute xmlAttribute, @NotNull CustomTemplateCallback callback) {
        if (xmlAttribute == null) {
            GenerationNode.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            GenerationNode.$$$reportNull$$$0(16);
        }
        if ("%boolean".equals(attributeValue)) {
            return true;
        }
        if (StringUtil.isEmpty((String)attributeValue)) {
            XmlAttributeDescriptor descriptor = xmlAttribute.getDescriptor();
            return descriptor != null && HtmlUtil.isBooleanAttribute(descriptor, callback.getContext());
        }
        return false;
    }

    private static boolean isImpliedAttribute(String xmlAttributeLocalName) {
        return StringUtil.startsWithChar((CharSequence)xmlAttributeLocalName, (char)'!');
    }

    private static boolean isEmptyValue(String attributeValue) {
        return attributeValue != null && (attributeValue.isEmpty() || ATTRIBUTE_VARIABLE_PATTERN.matcher(attributeValue).matches());
    }

    @Nullable
    private static XmlAttribute findImpliedAttribute(@NotNull List<? extends XmlAttribute> attributes) {
        if (attributes == null) {
            GenerationNode.$$$reportNull$$$0(17);
        }
        for (XmlAttribute xmlAttribute : attributes) {
            if (xmlAttribute.getValueElement() == null || !GenerationNode.isImpliedAttribute(xmlAttribute.getLocalName())) continue;
            return xmlAttribute;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute findEmptyAttribute(@NotNull List<? extends XmlAttribute> attributes) {
        if (attributes == null) {
            GenerationNode.$$$reportNull$$$0(18);
        }
        for (XmlAttribute xmlAttribute : attributes) {
            String attributeValue = xmlAttribute.getValue();
            if (!GenerationNode.isEmptyValue(attributeValue)) continue;
            return xmlAttribute;
        }
        return null;
    }

    private static boolean isNewLineBefore(CharSequence text2, int offset) {
        int i;
        for (i = offset - 1; i >= 0 && Character.isWhitespace(text2.charAt(i)); --i) {
            if (text2.charAt(i) != '\n') continue;
            return true;
        }
        return i < 0;
    }

    private static boolean isNewLineAfter(CharSequence text2, int offset) {
        int i;
        for (i = offset; i < text2.length() && Character.isWhitespace(text2.charAt(i)); ++i) {
            if (text2.charAt(i) != '\n') continue;
            return true;
        }
        return i == text2.length();
    }

    public TemplateToken getTemplateToken() {
        return this.myTemplateToken;
    }

    public String getSurroundedText() {
        return this.mySurroundedText;
    }

    public void setSurroundedText(String surroundedText) {
        this.mySurroundedText = surroundedText;
    }

    public GenerationNode getParent() {
        return this.myParent;
    }

    public void setParent(GenerationNode parent) {
        this.myParent = parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/nodes/GenerationNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/nodes/GenerationNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expandTemplate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "expandEmptyTagIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareVariableName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandEmptyTagIfNecessary";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildPredefinedValues";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeValues";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findImpliedAttribute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findEmptyAttribute";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 7, 9, 10 -> new IllegalStateException(string2);
        };
    }
}

