# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessKeys(_serialization.Model):
    """The secret access keys used for authenticating connections to redis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_key: The current primary key that clients can use to authenticate.
    :vartype primary_key: str
    :ivar secondary_key: The current secondary key that clients can use to authenticate.
    :vartype secondary_key: str
    """

    _validation = {
        "primary_key": {"readonly": True},
        "secondary_key": {"readonly": True},
    }

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_key = None
        self.secondary_key = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResourceAutoGenerated(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """


class AccessPolicyAssignment(ProxyResourceAutoGenerated):
    """Describes the access policy assignment of Redis Enterprise database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar provisioning_state: Current provisioning status of the access policy assignment. Known
     values are: "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar access_policy_name: Name of access policy under specific access policy assignment. Only
     "default" policy is supported for now.
    :vartype access_policy_name: str
    :ivar user: The user associated with the access policy.
    :vartype user: ~azure.mgmt.redisenterprise.models.AccessPolicyAssignmentPropertiesUser
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "access_policy_name": {"pattern": r"^([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]|[a-zA-Z0-9])$"},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "access_policy_name": {"key": "properties.accessPolicyName", "type": "str"},
        "user": {"key": "properties.user", "type": "AccessPolicyAssignmentPropertiesUser"},
    }

    def __init__(
        self,
        *,
        access_policy_name: Optional[str] = None,
        user: Optional["_models.AccessPolicyAssignmentPropertiesUser"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access_policy_name: Name of access policy under specific access policy assignment.
         Only "default" policy is supported for now.
        :paramtype access_policy_name: str
        :keyword user: The user associated with the access policy.
        :paramtype user: ~azure.mgmt.redisenterprise.models.AccessPolicyAssignmentPropertiesUser
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.access_policy_name = access_policy_name
        self.user = user


class AccessPolicyAssignmentList(_serialization.Model):
    """The response of a list-all operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of access policy assignments.
    :vartype value: list[~azure.mgmt.redisenterprise.models.AccessPolicyAssignment]
    :ivar next_link: The URI to fetch the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessPolicyAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AccessPolicyAssignment"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of access policy assignments.
        :paramtype value: list[~azure.mgmt.redisenterprise.models.AccessPolicyAssignment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AccessPolicyAssignmentPropertiesUser(_serialization.Model):
    """The user associated with the access policy.

    :ivar object_id: The object ID of the user.
    :vartype object_id: str
    """

    _attribute_map = {
        "object_id": {"key": "objectId", "type": "str"},
    }

    def __init__(self, *, object_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword object_id: The object ID of the user.
        :paramtype object_id: str
        """
        super().__init__(**kwargs)
        self.object_id = object_id


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Describes the Redis Enterprise cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: The SKU to create, which affects price, performance, and features. Required.
    :vartype sku: ~azure.mgmt.redisenterprise.models.Sku
    :ivar zones: The Availability Zones where this cluster will be deployed.
    :vartype zones: list[str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.redisenterprise.models.ManagedServiceIdentity
    :ivar high_availability: Enabled by default. If highAvailability is disabled, the data set is
     not replicated. This affects the availability SLA, and increases the risk of data loss. Known
     values are: "Enabled" and "Disabled".
    :vartype high_availability: str or ~azure.mgmt.redisenterprise.models.HighAvailability
    :ivar minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
     Newer versions can be added in the future. Note that TLS 1.0 and TLS 1.1 are now completely
     obsolete -- you cannot use them. They are mentioned only for the sake of consistency with old
     API versions. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redisenterprise.models.TlsVersion
    :ivar encryption: Encryption-at-rest configuration for the cluster.
    :vartype encryption: ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryption
    :ivar host_name: DNS name of the cluster endpoint.
    :vartype host_name: str
    :ivar provisioning_state: Current provisioning status of the cluster. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar redundancy_mode: Explains the current redundancy strategy of the cluster, which affects
     the expected SLA. Known values are: "None", "LR", and "ZR".
    :vartype redundancy_mode: str or ~azure.mgmt.redisenterprise.models.RedundancyMode
    :ivar resource_state: Current resource status of the cluster. Known values are: "Running",
     "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed", "Enabling",
     "EnableFailed", "Disabling", "DisableFailed", "Disabled", "Scaling", and "ScalingFailed".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :ivar redis_version: Version of redis the cluster supports, e.g. '6'.
    :vartype redis_version: str
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     specified Redis Enterprise cluster.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.redisenterprise.models.PrivateEndpointConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "host_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "redundancy_mode": {"readonly": True},
        "resource_state": {"readonly": True},
        "redis_version": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "high_availability": {"key": "properties.highAvailability", "type": "str"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "ClusterPropertiesEncryption"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "redundancy_mode": {"key": "properties.redundancyMode", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "redis_version": {"key": "properties.redisVersion", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        high_availability: Optional[Union[str, "_models.HighAvailability"]] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        encryption: Optional["_models.ClusterPropertiesEncryption"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The SKU to create, which affects price, performance, and features. Required.
        :paramtype sku: ~azure.mgmt.redisenterprise.models.Sku
        :keyword zones: The Availability Zones where this cluster will be deployed.
        :paramtype zones: list[str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.redisenterprise.models.ManagedServiceIdentity
        :keyword high_availability: Enabled by default. If highAvailability is disabled, the data set
         is not replicated. This affects the availability SLA, and increases the risk of data loss.
         Known values are: "Enabled" and "Disabled".
        :paramtype high_availability: str or ~azure.mgmt.redisenterprise.models.HighAvailability
        :keyword minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
         Newer versions can be added in the future. Note that TLS 1.0 and TLS 1.1 are now completely
         obsolete -- you cannot use them. They are mentioned only for the sake of consistency with old
         API versions. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redisenterprise.models.TlsVersion
        :keyword encryption: Encryption-at-rest configuration for the cluster.
        :paramtype encryption: ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryption
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.zones = zones
        self.identity = identity
        self.high_availability = high_availability
        self.minimum_tls_version = minimum_tls_version
        self.encryption = encryption
        self.host_name = None
        self.provisioning_state = None
        self.redundancy_mode = None
        self.resource_state = None
        self.redis_version = None
        self.private_endpoint_connections = None


class ClusterList(_serialization.Model):
    """The response of a list-all operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of clusters.
    :vartype value: list[~azure.mgmt.redisenterprise.models.Cluster]
    :ivar next_link: The URI to fetch the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Cluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Cluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of clusters.
        :paramtype value: list[~azure.mgmt.redisenterprise.models.Cluster]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterPropertiesEncryption(_serialization.Model):
    """Encryption-at-rest configuration for the cluster.

    :ivar customer_managed_key_encryption: All Customer-managed key encryption properties for the
     resource. Set this to an empty object to use Microsoft-managed key encryption.
    :vartype customer_managed_key_encryption:
     ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryptionCustomerManagedKeyEncryption
    """

    _attribute_map = {
        "customer_managed_key_encryption": {
            "key": "customerManagedKeyEncryption",
            "type": "ClusterPropertiesEncryptionCustomerManagedKeyEncryption",
        },
    }

    def __init__(
        self,
        *,
        customer_managed_key_encryption: Optional[
            "_models.ClusterPropertiesEncryptionCustomerManagedKeyEncryption"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword customer_managed_key_encryption: All Customer-managed key encryption properties for
         the resource. Set this to an empty object to use Microsoft-managed key encryption.
        :paramtype customer_managed_key_encryption:
         ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryptionCustomerManagedKeyEncryption
        """
        super().__init__(**kwargs)
        self.customer_managed_key_encryption = customer_managed_key_encryption


class ClusterPropertiesEncryptionCustomerManagedKeyEncryption(_serialization.Model):  # pylint: disable=name-too-long
    """All Customer-managed key encryption properties for the resource. Set this to an empty object to
    use Microsoft-managed key encryption.

    :ivar key_encryption_key_identity: All identity configuration for Customer-managed key settings
     defining which identity should be used to auth to Key Vault.
    :vartype key_encryption_key_identity:
     ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryptionCustomerManagedKeyEncryptionKeyIdentity
    :ivar key_encryption_key_url: Key encryption key Url, versioned only. Ex:
     https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78.
    :vartype key_encryption_key_url: str
    """

    _attribute_map = {
        "key_encryption_key_identity": {
            "key": "keyEncryptionKeyIdentity",
            "type": "ClusterPropertiesEncryptionCustomerManagedKeyEncryptionKeyIdentity",
        },
        "key_encryption_key_url": {"key": "keyEncryptionKeyUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_encryption_key_identity: Optional[
            "_models.ClusterPropertiesEncryptionCustomerManagedKeyEncryptionKeyIdentity"
        ] = None,
        key_encryption_key_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_encryption_key_identity: All identity configuration for Customer-managed key
         settings defining which identity should be used to auth to Key Vault.
        :paramtype key_encryption_key_identity:
         ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryptionCustomerManagedKeyEncryptionKeyIdentity
        :keyword key_encryption_key_url: Key encryption key Url, versioned only. Ex:
         https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78.
        :paramtype key_encryption_key_url: str
        """
        super().__init__(**kwargs)
        self.key_encryption_key_identity = key_encryption_key_identity
        self.key_encryption_key_url = key_encryption_key_url


class ClusterPropertiesEncryptionCustomerManagedKeyEncryptionKeyIdentity(
    _serialization.Model
):  # pylint: disable=name-too-long
    """All identity configuration for Customer-managed key settings defining which identity should be
    used to auth to Key Vault.

    :ivar user_assigned_identity_resource_id: User assigned identity to use for accessing key
     encryption key Url. Ex: /subscriptions/:code:`<sub uuid>`/resourceGroups/:code:`<resource
     group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
    :vartype user_assigned_identity_resource_id: str
    :ivar identity_type: Only userAssignedIdentity is supported in this API version; other types
     may be supported in the future. Known values are: "systemAssignedIdentity" and
     "userAssignedIdentity".
    :vartype identity_type: str or ~azure.mgmt.redisenterprise.models.CmkIdentityType
    """

    _attribute_map = {
        "user_assigned_identity_resource_id": {"key": "userAssignedIdentityResourceId", "type": "str"},
        "identity_type": {"key": "identityType", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_assigned_identity_resource_id: Optional[str] = None,
        identity_type: Optional[Union[str, "_models.CmkIdentityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_assigned_identity_resource_id: User assigned identity to use for accessing key
         encryption key Url. Ex: /subscriptions/:code:`<sub uuid>`/resourceGroups/:code:`<resource
         group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
        :paramtype user_assigned_identity_resource_id: str
        :keyword identity_type: Only userAssignedIdentity is supported in this API version; other types
         may be supported in the future. Known values are: "systemAssignedIdentity" and
         "userAssignedIdentity".
        :paramtype identity_type: str or ~azure.mgmt.redisenterprise.models.CmkIdentityType
        """
        super().__init__(**kwargs)
        self.user_assigned_identity_resource_id = user_assigned_identity_resource_id
        self.identity_type = identity_type


class ClusterUpdate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A partial update to the Redis Enterprise cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The SKU to create, which affects price, performance, and features.
    :vartype sku: ~azure.mgmt.redisenterprise.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.redisenterprise.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar high_availability: Enabled by default. If highAvailability is disabled, the data set is
     not replicated. This affects the availability SLA, and increases the risk of data loss. Known
     values are: "Enabled" and "Disabled".
    :vartype high_availability: str or ~azure.mgmt.redisenterprise.models.HighAvailability
    :ivar minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
     Newer versions can be added in the future. Note that TLS 1.0 and TLS 1.1 are now completely
     obsolete -- you cannot use them. They are mentioned only for the sake of consistency with old
     API versions. Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redisenterprise.models.TlsVersion
    :ivar encryption: Encryption-at-rest configuration for the cluster.
    :vartype encryption: ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryption
    :ivar host_name: DNS name of the cluster endpoint.
    :vartype host_name: str
    :ivar provisioning_state: Current provisioning status of the cluster. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar redundancy_mode: Explains the current redundancy strategy of the cluster, which affects
     the expected SLA. Known values are: "None", "LR", and "ZR".
    :vartype redundancy_mode: str or ~azure.mgmt.redisenterprise.models.RedundancyMode
    :ivar resource_state: Current resource status of the cluster. Known values are: "Running",
     "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed", "Enabling",
     "EnableFailed", "Disabling", "DisableFailed", "Disabled", "Scaling", and "ScalingFailed".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :ivar redis_version: Version of redis the cluster supports, e.g. '6'.
    :vartype redis_version: str
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     specified Redis Enterprise cluster.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.redisenterprise.models.PrivateEndpointConnection]
    """

    _validation = {
        "host_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "redundancy_mode": {"readonly": True},
        "resource_state": {"readonly": True},
        "redis_version": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "high_availability": {"key": "properties.highAvailability", "type": "str"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "ClusterPropertiesEncryption"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "redundancy_mode": {"key": "properties.redundancyMode", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "redis_version": {"key": "properties.redisVersion", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        high_availability: Optional[Union[str, "_models.HighAvailability"]] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        encryption: Optional["_models.ClusterPropertiesEncryption"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The SKU to create, which affects price, performance, and features.
        :paramtype sku: ~azure.mgmt.redisenterprise.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.redisenterprise.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword high_availability: Enabled by default. If highAvailability is disabled, the data set
         is not replicated. This affects the availability SLA, and increases the risk of data loss.
         Known values are: "Enabled" and "Disabled".
        :paramtype high_availability: str or ~azure.mgmt.redisenterprise.models.HighAvailability
        :keyword minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
         Newer versions can be added in the future. Note that TLS 1.0 and TLS 1.1 are now completely
         obsolete -- you cannot use them. They are mentioned only for the sake of consistency with old
         API versions. Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redisenterprise.models.TlsVersion
        :keyword encryption: Encryption-at-rest configuration for the cluster.
        :paramtype encryption: ~azure.mgmt.redisenterprise.models.ClusterPropertiesEncryption
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.identity = identity
        self.tags = tags
        self.high_availability = high_availability
        self.minimum_tls_version = minimum_tls_version
        self.encryption = encryption
        self.host_name = None
        self.provisioning_state = None
        self.redundancy_mode = None
        self.resource_state = None
        self.redis_version = None
        self.private_endpoint_connections = None


class ResourceAutoGenerated(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redisenterprise.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(ResourceAutoGenerated):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redisenterprise.models.SystemData
    """


class Database(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Describes a database on the Redis Enterprise cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.redisenterprise.models.SystemData
    :ivar client_protocol: Specifies whether redis clients can connect using TLS-encrypted or
     plaintext redis protocols. Default is TLS-encrypted. Known values are: "Encrypted" and
     "Plaintext".
    :vartype client_protocol: str or ~azure.mgmt.redisenterprise.models.Protocol
    :ivar port: TCP port of the database endpoint. Specified at create time. Defaults to an
     available port.
    :vartype port: int
    :ivar provisioning_state: Current provisioning status of the database. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar resource_state: Current resource status of the database. Known values are: "Running",
     "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed", "Enabling",
     "EnableFailed", "Disabling", "DisableFailed", "Disabled", "Scaling", and "ScalingFailed".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :ivar clustering_policy: Clustering policy - default is OSSCluster. This property must be
     chosen at create time, and cannot be changed without deleting the database. Known values are:
     "EnterpriseCluster" and "OSSCluster".
    :vartype clustering_policy: str or ~azure.mgmt.redisenterprise.models.ClusteringPolicy
    :ivar eviction_policy: Redis eviction policy - default is VolatileLRU. Known values are:
     "AllKeysLFU", "AllKeysLRU", "AllKeysRandom", "VolatileLRU", "VolatileLFU", "VolatileTTL",
     "VolatileRandom", and "NoEviction".
    :vartype eviction_policy: str or ~azure.mgmt.redisenterprise.models.EvictionPolicy
    :ivar persistence: Persistence settings.
    :vartype persistence: ~azure.mgmt.redisenterprise.models.Persistence
    :ivar modules: Optional set of redis modules to enable in this database - modules can only be
     added at creation time.
    :vartype modules: list[~azure.mgmt.redisenterprise.models.Module]
    :ivar geo_replication: Optional set of properties to configure geo replication for this
     database.
    :vartype geo_replication: ~azure.mgmt.redisenterprise.models.DatabasePropertiesGeoReplication
    :ivar redis_version: Version of Redis the database is running on, e.g. '6.0'.
    :vartype redis_version: str
    :ivar defer_upgrade: Option to defer upgrade when newest version is released - default is
     NotDeferred. Learn more: https://aka.ms/redisversionupgrade. Known values are: "Deferred" and
     "NotDeferred".
    :vartype defer_upgrade: str or ~azure.mgmt.redisenterprise.models.DeferUpgradeSetting
    :ivar access_keys_authentication: This property can be Enabled/Disabled to allow or deny access
     with the current access keys. Can be updated even after database is created. Known values are:
     "Disabled" and "Enabled".
    :vartype access_keys_authentication: str or
     ~azure.mgmt.redisenterprise.models.AccessKeysAuthentication
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_state": {"readonly": True},
        "redis_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "client_protocol": {"key": "properties.clientProtocol", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "clustering_policy": {"key": "properties.clusteringPolicy", "type": "str"},
        "eviction_policy": {"key": "properties.evictionPolicy", "type": "str"},
        "persistence": {"key": "properties.persistence", "type": "Persistence"},
        "modules": {"key": "properties.modules", "type": "[Module]"},
        "geo_replication": {"key": "properties.geoReplication", "type": "DatabasePropertiesGeoReplication"},
        "redis_version": {"key": "properties.redisVersion", "type": "str"},
        "defer_upgrade": {"key": "properties.deferUpgrade", "type": "str"},
        "access_keys_authentication": {"key": "properties.accessKeysAuthentication", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_protocol: Optional[Union[str, "_models.Protocol"]] = None,
        port: Optional[int] = None,
        clustering_policy: Optional[Union[str, "_models.ClusteringPolicy"]] = None,
        eviction_policy: Optional[Union[str, "_models.EvictionPolicy"]] = None,
        persistence: Optional["_models.Persistence"] = None,
        modules: Optional[List["_models.Module"]] = None,
        geo_replication: Optional["_models.DatabasePropertiesGeoReplication"] = None,
        defer_upgrade: Optional[Union[str, "_models.DeferUpgradeSetting"]] = None,
        access_keys_authentication: Optional[Union[str, "_models.AccessKeysAuthentication"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_protocol: Specifies whether redis clients can connect using TLS-encrypted or
         plaintext redis protocols. Default is TLS-encrypted. Known values are: "Encrypted" and
         "Plaintext".
        :paramtype client_protocol: str or ~azure.mgmt.redisenterprise.models.Protocol
        :keyword port: TCP port of the database endpoint. Specified at create time. Defaults to an
         available port.
        :paramtype port: int
        :keyword clustering_policy: Clustering policy - default is OSSCluster. This property must be
         chosen at create time, and cannot be changed without deleting the database. Known values are:
         "EnterpriseCluster" and "OSSCluster".
        :paramtype clustering_policy: str or ~azure.mgmt.redisenterprise.models.ClusteringPolicy
        :keyword eviction_policy: Redis eviction policy - default is VolatileLRU. Known values are:
         "AllKeysLFU", "AllKeysLRU", "AllKeysRandom", "VolatileLRU", "VolatileLFU", "VolatileTTL",
         "VolatileRandom", and "NoEviction".
        :paramtype eviction_policy: str or ~azure.mgmt.redisenterprise.models.EvictionPolicy
        :keyword persistence: Persistence settings.
        :paramtype persistence: ~azure.mgmt.redisenterprise.models.Persistence
        :keyword modules: Optional set of redis modules to enable in this database - modules can only
         be added at creation time.
        :paramtype modules: list[~azure.mgmt.redisenterprise.models.Module]
        :keyword geo_replication: Optional set of properties to configure geo replication for this
         database.
        :paramtype geo_replication: ~azure.mgmt.redisenterprise.models.DatabasePropertiesGeoReplication
        :keyword defer_upgrade: Option to defer upgrade when newest version is released - default is
         NotDeferred. Learn more: https://aka.ms/redisversionupgrade. Known values are: "Deferred" and
         "NotDeferred".
        :paramtype defer_upgrade: str or ~azure.mgmt.redisenterprise.models.DeferUpgradeSetting
        :keyword access_keys_authentication: This property can be Enabled/Disabled to allow or deny
         access with the current access keys. Can be updated even after database is created. Known
         values are: "Disabled" and "Enabled".
        :paramtype access_keys_authentication: str or
         ~azure.mgmt.redisenterprise.models.AccessKeysAuthentication
        """
        super().__init__(**kwargs)
        self.client_protocol = client_protocol
        self.port = port
        self.provisioning_state = None
        self.resource_state = None
        self.clustering_policy = clustering_policy
        self.eviction_policy = eviction_policy
        self.persistence = persistence
        self.modules = modules
        self.geo_replication = geo_replication
        self.redis_version = None
        self.defer_upgrade = defer_upgrade
        self.access_keys_authentication = access_keys_authentication


class DatabaseList(_serialization.Model):
    """The response of a list-all operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of databases.
    :vartype value: list[~azure.mgmt.redisenterprise.models.Database]
    :ivar next_link: The URI to fetch the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Database]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Database"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of databases.
        :paramtype value: list[~azure.mgmt.redisenterprise.models.Database]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DatabasePropertiesGeoReplication(_serialization.Model):
    """Optional set of properties to configure geo replication for this database.

    :ivar group_nickname: Name for the group of linked database resources.
    :vartype group_nickname: str
    :ivar linked_databases: List of database resources to link with this database.
    :vartype linked_databases: list[~azure.mgmt.redisenterprise.models.LinkedDatabase]
    """

    _attribute_map = {
        "group_nickname": {"key": "groupNickname", "type": "str"},
        "linked_databases": {"key": "linkedDatabases", "type": "[LinkedDatabase]"},
    }

    def __init__(
        self,
        *,
        group_nickname: Optional[str] = None,
        linked_databases: Optional[List["_models.LinkedDatabase"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword group_nickname: Name for the group of linked database resources.
        :paramtype group_nickname: str
        :keyword linked_databases: List of database resources to link with this database.
        :paramtype linked_databases: list[~azure.mgmt.redisenterprise.models.LinkedDatabase]
        """
        super().__init__(**kwargs)
        self.group_nickname = group_nickname
        self.linked_databases = linked_databases


class DatabaseUpdate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A partial update to the Redis Enterprise database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar client_protocol: Specifies whether redis clients can connect using TLS-encrypted or
     plaintext redis protocols. Default is TLS-encrypted. Known values are: "Encrypted" and
     "Plaintext".
    :vartype client_protocol: str or ~azure.mgmt.redisenterprise.models.Protocol
    :ivar port: TCP port of the database endpoint. Specified at create time. Defaults to an
     available port.
    :vartype port: int
    :ivar provisioning_state: Current provisioning status of the database. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar resource_state: Current resource status of the database. Known values are: "Running",
     "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed", "Enabling",
     "EnableFailed", "Disabling", "DisableFailed", "Disabled", "Scaling", and "ScalingFailed".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :ivar clustering_policy: Clustering policy - default is OSSCluster. This property must be
     chosen at create time, and cannot be changed without deleting the database. Known values are:
     "EnterpriseCluster" and "OSSCluster".
    :vartype clustering_policy: str or ~azure.mgmt.redisenterprise.models.ClusteringPolicy
    :ivar eviction_policy: Redis eviction policy - default is VolatileLRU. Known values are:
     "AllKeysLFU", "AllKeysLRU", "AllKeysRandom", "VolatileLRU", "VolatileLFU", "VolatileTTL",
     "VolatileRandom", and "NoEviction".
    :vartype eviction_policy: str or ~azure.mgmt.redisenterprise.models.EvictionPolicy
    :ivar persistence: Persistence settings.
    :vartype persistence: ~azure.mgmt.redisenterprise.models.Persistence
    :ivar modules: Optional set of redis modules to enable in this database - modules can only be
     added at creation time.
    :vartype modules: list[~azure.mgmt.redisenterprise.models.Module]
    :ivar geo_replication: Optional set of properties to configure geo replication for this
     database.
    :vartype geo_replication: ~azure.mgmt.redisenterprise.models.DatabasePropertiesGeoReplication
    :ivar redis_version: Version of Redis the database is running on, e.g. '6.0'.
    :vartype redis_version: str
    :ivar defer_upgrade: Option to defer upgrade when newest version is released - default is
     NotDeferred. Learn more: https://aka.ms/redisversionupgrade. Known values are: "Deferred" and
     "NotDeferred".
    :vartype defer_upgrade: str or ~azure.mgmt.redisenterprise.models.DeferUpgradeSetting
    :ivar access_keys_authentication: This property can be Enabled/Disabled to allow or deny access
     with the current access keys. Can be updated even after database is created. Known values are:
     "Disabled" and "Enabled".
    :vartype access_keys_authentication: str or
     ~azure.mgmt.redisenterprise.models.AccessKeysAuthentication
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "resource_state": {"readonly": True},
        "redis_version": {"readonly": True},
    }

    _attribute_map = {
        "client_protocol": {"key": "properties.clientProtocol", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "clustering_policy": {"key": "properties.clusteringPolicy", "type": "str"},
        "eviction_policy": {"key": "properties.evictionPolicy", "type": "str"},
        "persistence": {"key": "properties.persistence", "type": "Persistence"},
        "modules": {"key": "properties.modules", "type": "[Module]"},
        "geo_replication": {"key": "properties.geoReplication", "type": "DatabasePropertiesGeoReplication"},
        "redis_version": {"key": "properties.redisVersion", "type": "str"},
        "defer_upgrade": {"key": "properties.deferUpgrade", "type": "str"},
        "access_keys_authentication": {"key": "properties.accessKeysAuthentication", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_protocol: Optional[Union[str, "_models.Protocol"]] = None,
        port: Optional[int] = None,
        clustering_policy: Optional[Union[str, "_models.ClusteringPolicy"]] = None,
        eviction_policy: Optional[Union[str, "_models.EvictionPolicy"]] = None,
        persistence: Optional["_models.Persistence"] = None,
        modules: Optional[List["_models.Module"]] = None,
        geo_replication: Optional["_models.DatabasePropertiesGeoReplication"] = None,
        defer_upgrade: Optional[Union[str, "_models.DeferUpgradeSetting"]] = None,
        access_keys_authentication: Optional[Union[str, "_models.AccessKeysAuthentication"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_protocol: Specifies whether redis clients can connect using TLS-encrypted or
         plaintext redis protocols. Default is TLS-encrypted. Known values are: "Encrypted" and
         "Plaintext".
        :paramtype client_protocol: str or ~azure.mgmt.redisenterprise.models.Protocol
        :keyword port: TCP port of the database endpoint. Specified at create time. Defaults to an
         available port.
        :paramtype port: int
        :keyword clustering_policy: Clustering policy - default is OSSCluster. This property must be
         chosen at create time, and cannot be changed without deleting the database. Known values are:
         "EnterpriseCluster" and "OSSCluster".
        :paramtype clustering_policy: str or ~azure.mgmt.redisenterprise.models.ClusteringPolicy
        :keyword eviction_policy: Redis eviction policy - default is VolatileLRU. Known values are:
         "AllKeysLFU", "AllKeysLRU", "AllKeysRandom", "VolatileLRU", "VolatileLFU", "VolatileTTL",
         "VolatileRandom", and "NoEviction".
        :paramtype eviction_policy: str or ~azure.mgmt.redisenterprise.models.EvictionPolicy
        :keyword persistence: Persistence settings.
        :paramtype persistence: ~azure.mgmt.redisenterprise.models.Persistence
        :keyword modules: Optional set of redis modules to enable in this database - modules can only
         be added at creation time.
        :paramtype modules: list[~azure.mgmt.redisenterprise.models.Module]
        :keyword geo_replication: Optional set of properties to configure geo replication for this
         database.
        :paramtype geo_replication: ~azure.mgmt.redisenterprise.models.DatabasePropertiesGeoReplication
        :keyword defer_upgrade: Option to defer upgrade when newest version is released - default is
         NotDeferred. Learn more: https://aka.ms/redisversionupgrade. Known values are: "Deferred" and
         "NotDeferred".
        :paramtype defer_upgrade: str or ~azure.mgmt.redisenterprise.models.DeferUpgradeSetting
        :keyword access_keys_authentication: This property can be Enabled/Disabled to allow or deny
         access with the current access keys. Can be updated even after database is created. Known
         values are: "Disabled" and "Enabled".
        :paramtype access_keys_authentication: str or
         ~azure.mgmt.redisenterprise.models.AccessKeysAuthentication
        """
        super().__init__(**kwargs)
        self.client_protocol = client_protocol
        self.port = port
        self.provisioning_state = None
        self.resource_state = None
        self.clustering_policy = clustering_policy
        self.eviction_policy = eviction_policy
        self.persistence = persistence
        self.modules = modules
        self.geo_replication = geo_replication
        self.redis_version = None
        self.defer_upgrade = defer_upgrade
        self.access_keys_authentication = access_keys_authentication


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.redisenterprise.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.redisenterprise.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.redisenterprise.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.redisenterprise.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExportClusterParameters(_serialization.Model):
    """Parameters for a Redis Enterprise export operation.

    All required parameters must be populated in order to send to server.

    :ivar sas_uri: SAS URI for the target directory to export to. Required.
    :vartype sas_uri: str
    """

    _validation = {
        "sas_uri": {"required": True},
    }

    _attribute_map = {
        "sas_uri": {"key": "sasUri", "type": "str"},
    }

    def __init__(self, *, sas_uri: str, **kwargs: Any) -> None:
        """
        :keyword sas_uri: SAS URI for the target directory to export to. Required.
        :paramtype sas_uri: str
        """
        super().__init__(**kwargs)
        self.sas_uri = sas_uri


class FlushParameters(_serialization.Model):
    """Parameters for a Redis Enterprise active geo-replication flush operation.

    :ivar ids: The identifiers of all the other database resources in the georeplication group to
     be flushed.
    :vartype ids: list[str]
    """

    _attribute_map = {
        "ids": {"key": "ids", "type": "[str]"},
    }

    def __init__(self, *, ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword ids: The identifiers of all the other database resources in the georeplication group
         to be flushed.
        :paramtype ids: list[str]
        """
        super().__init__(**kwargs)
        self.ids = ids


class ForceLinkParameters(_serialization.Model):
    """Parameters for reconfiguring active geo-replication, of an existing database that was
    previously unlinked from a replication group.

    All required parameters must be populated in order to send to server.

    :ivar group_nickname: The name of the group of linked database resources. This should match the
     existing replication group name. Required.
    :vartype group_nickname: str
    :ivar linked_databases: The resource IDs of the databases that are expected to be linked and
     included in the replication group. This parameter is used to validate that the linking is to
     the expected (unlinked) part of the replication group, if it is splintered. Required.
    :vartype linked_databases: list[~azure.mgmt.redisenterprise.models.LinkedDatabase]
    """

    _validation = {
        "group_nickname": {"required": True},
        "linked_databases": {"required": True},
    }

    _attribute_map = {
        "group_nickname": {"key": "groupNickname", "type": "str"},
        "linked_databases": {"key": "linkedDatabases", "type": "[LinkedDatabase]"},
    }

    def __init__(self, *, group_nickname: str, linked_databases: List["_models.LinkedDatabase"], **kwargs: Any) -> None:
        """
        :keyword group_nickname: The name of the group of linked database resources. This should match
         the existing replication group name. Required.
        :paramtype group_nickname: str
        :keyword linked_databases: The resource IDs of the databases that are expected to be linked and
         included in the replication group. This parameter is used to validate that the linking is to
         the expected (unlinked) part of the replication group, if it is splintered. Required.
        :paramtype linked_databases: list[~azure.mgmt.redisenterprise.models.LinkedDatabase]
        """
        super().__init__(**kwargs)
        self.group_nickname = group_nickname
        self.linked_databases = linked_databases


class ForceUnlinkParameters(_serialization.Model):
    """Parameters for a redis enterprise active geo-replication force unlink operation.

    All required parameters must be populated in order to send to server.

    :ivar ids: The resource IDs of the database resources to be unlinked. Required.
    :vartype ids: list[str]
    """

    _validation = {
        "ids": {"required": True},
    }

    _attribute_map = {
        "ids": {"key": "ids", "type": "[str]"},
    }

    def __init__(self, *, ids: List[str], **kwargs: Any) -> None:
        """
        :keyword ids: The resource IDs of the database resources to be unlinked. Required.
        :paramtype ids: list[str]
        """
        super().__init__(**kwargs)
        self.ids = ids


class ImportClusterParameters(_serialization.Model):
    """Parameters for a Redis Enterprise import operation.

    All required parameters must be populated in order to send to server.

    :ivar sas_uris: SAS URIs for the target blobs to import from. Required.
    :vartype sas_uris: list[str]
    """

    _validation = {
        "sas_uris": {"required": True},
    }

    _attribute_map = {
        "sas_uris": {"key": "sasUris", "type": "[str]"},
    }

    def __init__(self, *, sas_uris: List[str], **kwargs: Any) -> None:
        """
        :keyword sas_uris: SAS URIs for the target blobs to import from. Required.
        :paramtype sas_uris: list[str]
        """
        super().__init__(**kwargs)
        self.sas_uris = sas_uris


class LinkedDatabase(_serialization.Model):
    """Specifies details of a linked database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of a database resource to link with this database.
    :vartype id: str
    :ivar state: State of the link between the database resources. Known values are: "Linked",
     "Linking", "Unlinking", "LinkFailed", and "UnlinkFailed".
    :vartype state: str or ~azure.mgmt.redisenterprise.models.LinkState
    """

    _validation = {
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of a database resource to link with this database.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.state = None


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.redisenterprise.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.redisenterprise.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.redisenterprise.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.  # pylint: disable=line-too-long
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.redisenterprise.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Module(_serialization.Model):
    """Specifies configuration of a redis module.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'.
     Required.
    :vartype name: str
    :ivar args: Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
    :vartype args: str
    :ivar version: The version of the module, e.g. '1.0'.
    :vartype version: str
    """

    _validation = {
        "name": {"required": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "args": {"key": "args", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, name: str, args: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'.
         Required.
        :paramtype name: str
        :keyword args: Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
        :paramtype args: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.args = args
        self.version = None


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.redisenterprise.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.redisenterprise.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.redisenterprise.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.redisenterprise.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.redisenterprise.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatus(_serialization.Model):
    """The status of a long-running operation.

    :ivar id: The operation's unique id.
    :vartype id: str
    :ivar name: The operation's name.
    :vartype name: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: str
    :ivar end_time: The end time of the operation.
    :vartype end_time: str
    :ivar status: The current status of the operation.
    :vartype status: str
    :ivar error: Error response describing why the operation failed.
    :vartype error: ~azure.mgmt.redisenterprise.models.ErrorResponse
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        status: Optional[str] = None,
        error: Optional["_models.ErrorResponse"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The operation's unique id.
        :paramtype id: str
        :keyword name: The operation's name.
        :paramtype name: str
        :keyword start_time: The start time of the operation.
        :paramtype start_time: str
        :keyword end_time: The end time of the operation.
        :paramtype end_time: str
        :keyword status: The current status of the operation.
        :paramtype status: str
        :keyword error: Error response describing why the operation failed.
        :paramtype error: ~azure.mgmt.redisenterprise.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error


class Persistence(_serialization.Model):
    """Persistence-related configuration for the Redis Enterprise database.

    :ivar aof_enabled: Sets whether AOF is enabled. Note that at most one of AOF or RDB persistence
     may be enabled.
    :vartype aof_enabled: bool
    :ivar rdb_enabled: Sets whether RDB is enabled. Note that at most one of AOF or RDB persistence
     may be enabled.
    :vartype rdb_enabled: bool
    :ivar aof_frequency: Sets the frequency at which data is written to disk. Defaults to '1s',
     meaning 'every second'. Note that the 'always' setting is deprecated, because of its
     performance impact. Known values are: "1s" and "always".
    :vartype aof_frequency: str or ~azure.mgmt.redisenterprise.models.AofFrequency
    :ivar rdb_frequency: Sets the frequency at which a snapshot of the database is created. Known
     values are: "1h", "6h", and "12h".
    :vartype rdb_frequency: str or ~azure.mgmt.redisenterprise.models.RdbFrequency
    """

    _attribute_map = {
        "aof_enabled": {"key": "aofEnabled", "type": "bool"},
        "rdb_enabled": {"key": "rdbEnabled", "type": "bool"},
        "aof_frequency": {"key": "aofFrequency", "type": "str"},
        "rdb_frequency": {"key": "rdbFrequency", "type": "str"},
    }

    def __init__(
        self,
        *,
        aof_enabled: Optional[bool] = None,
        rdb_enabled: Optional[bool] = None,
        aof_frequency: Optional[Union[str, "_models.AofFrequency"]] = None,
        rdb_frequency: Optional[Union[str, "_models.RdbFrequency"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword aof_enabled: Sets whether AOF is enabled. Note that at most one of AOF or RDB
         persistence may be enabled.
        :paramtype aof_enabled: bool
        :keyword rdb_enabled: Sets whether RDB is enabled. Note that at most one of AOF or RDB
         persistence may be enabled.
        :paramtype rdb_enabled: bool
        :keyword aof_frequency: Sets the frequency at which data is written to disk. Defaults to '1s',
         meaning 'every second'. Note that the 'always' setting is deprecated, because of its
         performance impact. Known values are: "1s" and "always".
        :paramtype aof_frequency: str or ~azure.mgmt.redisenterprise.models.AofFrequency
        :keyword rdb_frequency: Sets the frequency at which a snapshot of the database is created.
         Known values are: "1h", "6h", and "12h".
        :paramtype rdb_frequency: str or ~azure.mgmt.redisenterprise.models.RdbFrequency
        """
        super().__init__(**kwargs)
        self.aof_enabled = aof_enabled
        self.rdb_enabled = rdb_enabled
        self.aof_frequency = aof_frequency
        self.rdb_frequency = rdb_frequency


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.redisenterprise.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.redisenterprise.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.redisenterprise.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.redisenterprise.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.redisenterprise.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.redisenterprise.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.redisenterprise.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.redisenterprise.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.redisenterprise.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.redisenterprise.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.redisenterprise.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class RegenerateKeyParameters(_serialization.Model):
    """Specifies which access keys to reset to a new random value.

    All required parameters must be populated in order to send to server.

    :ivar key_type: Which access key to regenerate. Required. Known values are: "Primary" and
     "Secondary".
    :vartype key_type: str or ~azure.mgmt.redisenterprise.models.AccessKeyType
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(self, *, key_type: Union[str, "_models.AccessKeyType"], **kwargs: Any) -> None:
        """
        :keyword key_type: Which access key to regenerate. Required. Known values are: "Primary" and
         "Secondary".
        :paramtype key_type: str or ~azure.mgmt.redisenterprise.models.AccessKeyType
        """
        super().__init__(**kwargs)
        self.key_type = key_type


class Sku(_serialization.Model):
    """SKU parameters supplied to the create Redis Enterprise cluster operation.

    All required parameters must be populated in order to send to server.

    :ivar name: The level of Redis Enterprise cluster to deploy. Possible values: ('Balanced_B5',
     'MemoryOptimized_M10', 'ComputeOptimized_X5', etc.). For more information on SKUs see the
     latest pricing documentation. Note that additional SKUs may become supported in the future.
     Required. Known values are: "Enterprise_E1", "Enterprise_E5", "Enterprise_E10",
     "Enterprise_E20", "Enterprise_E50", "Enterprise_E100", "Enterprise_E200", "Enterprise_E400",
     "EnterpriseFlash_F300", "EnterpriseFlash_F700", "EnterpriseFlash_F1500", "Balanced_B0",
     "Balanced_B1", "Balanced_B3", "Balanced_B5", "Balanced_B10", "Balanced_B20", "Balanced_B50",
     "Balanced_B100", "Balanced_B150", "Balanced_B250", "Balanced_B350", "Balanced_B500",
     "Balanced_B700", "Balanced_B1000", "MemoryOptimized_M10", "MemoryOptimized_M20",
     "MemoryOptimized_M50", "MemoryOptimized_M100", "MemoryOptimized_M150", "MemoryOptimized_M250",
     "MemoryOptimized_M350", "MemoryOptimized_M500", "MemoryOptimized_M700",
     "MemoryOptimized_M1000", "MemoryOptimized_M1500", "MemoryOptimized_M2000",
     "ComputeOptimized_X3", "ComputeOptimized_X5", "ComputeOptimized_X10", "ComputeOptimized_X20",
     "ComputeOptimized_X50", "ComputeOptimized_X100", "ComputeOptimized_X150",
     "ComputeOptimized_X250", "ComputeOptimized_X350", "ComputeOptimized_X500",
     "ComputeOptimized_X700", "FlashOptimized_A250", "FlashOptimized_A500", "FlashOptimized_A700",
     "FlashOptimized_A1000", "FlashOptimized_A1500", "FlashOptimized_A2000", and
     "FlashOptimized_A4500".
    :vartype name: str or ~azure.mgmt.redisenterprise.models.SkuName
    :ivar capacity: This property is only used with Enterprise and EnterpriseFlash SKUs. Determines
     the size of the cluster. Valid values are (2, 4, 6, ...) for Enterprise SKUs and (3, 9, 15,
     ...) for EnterpriseFlash SKUs.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(self, *, name: Union[str, "_models.SkuName"], capacity: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword name: The level of Redis Enterprise cluster to deploy. Possible values:
         ('Balanced_B5', 'MemoryOptimized_M10', 'ComputeOptimized_X5', etc.). For more information on
         SKUs see the latest pricing documentation. Note that additional SKUs may become supported in
         the future. Required. Known values are: "Enterprise_E1", "Enterprise_E5", "Enterprise_E10",
         "Enterprise_E20", "Enterprise_E50", "Enterprise_E100", "Enterprise_E200", "Enterprise_E400",
         "EnterpriseFlash_F300", "EnterpriseFlash_F700", "EnterpriseFlash_F1500", "Balanced_B0",
         "Balanced_B1", "Balanced_B3", "Balanced_B5", "Balanced_B10", "Balanced_B20", "Balanced_B50",
         "Balanced_B100", "Balanced_B150", "Balanced_B250", "Balanced_B350", "Balanced_B500",
         "Balanced_B700", "Balanced_B1000", "MemoryOptimized_M10", "MemoryOptimized_M20",
         "MemoryOptimized_M50", "MemoryOptimized_M100", "MemoryOptimized_M150", "MemoryOptimized_M250",
         "MemoryOptimized_M350", "MemoryOptimized_M500", "MemoryOptimized_M700",
         "MemoryOptimized_M1000", "MemoryOptimized_M1500", "MemoryOptimized_M2000",
         "ComputeOptimized_X3", "ComputeOptimized_X5", "ComputeOptimized_X10", "ComputeOptimized_X20",
         "ComputeOptimized_X50", "ComputeOptimized_X100", "ComputeOptimized_X150",
         "ComputeOptimized_X250", "ComputeOptimized_X350", "ComputeOptimized_X500",
         "ComputeOptimized_X700", "FlashOptimized_A250", "FlashOptimized_A500", "FlashOptimized_A700",
         "FlashOptimized_A1000", "FlashOptimized_A1500", "FlashOptimized_A2000", and
         "FlashOptimized_A4500".
        :paramtype name: str or ~azure.mgmt.redisenterprise.models.SkuName
        :keyword capacity: This property is only used with Enterprise and EnterpriseFlash SKUs.
         Determines the size of the cluster. Valid values are (2, 4, 6, ...) for Enterprise SKUs and (3,
         9, 15, ...) for EnterpriseFlash SKUs.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.redisenterprise.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.redisenterprise.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.redisenterprise.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.redisenterprise.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
