# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DocumentDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of supported Data Types."""

    PLAINTEXT = "Plaintext"
    """Plain text data type."""


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of statuses a job can have."""

    NOT_STARTED = "NotStarted"
    """Job has been submitted and is waiting to be processed."""
    RUNNING = "Running"
    """Job has been started."""
    SUCCEEDED = "Succeeded"
    """Job has completed successfully. All documents have succeeded."""
    PARTIAL_FAILED = "PartialFailed"
    """Job has completed with at least a single document failing."""
    FAILED = "Failed"
    """Job has completed with all documents failing, or a validation failure."""
    CANCELED = "Canceled"
    """Job has been canceled after user request."""


class OperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum describing allowed operation states."""

    NOT_STARTED = "NotStarted"
    """The operation has not started."""
    RUNNING = "Running"
    """The operation is in progress."""
    SUCCEEDED = "Succeeded"
    """The operation has completed successfully."""
    FAILED = "Failed"
    """The operation has failed."""
    CANCELED = "Canceled"
    """The operation has been canceled by the user."""


class OperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of supported Operation Types."""

    REDACT = "Redact"
    """Redact Operation will remove all entities of PHI and replace them with a placeholder value."""
    SURROGATE = "Surrogate"
    """Surrogation Operation will replace all entities of PHI with a surrogate value."""
    TAG = "Tag"
    """Tag Operation will detect all entities of PHI, their type, and return their locations in the
    document."""


class PhiCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of PHI Entities."""

    UNKNOWN = "Unknown"
    """Unknown PHI Type."""
    ACCOUNT = "Account"
    """Account Number."""
    AGE = "Age"
    """Age."""
    BIO_I_D = "BioID"
    """Biological Identifier, such as a fingerprint or retinal scan."""
    CITY = "City"
    """City."""
    COUNTRY_OR_REGION = "CountryOrRegion"
    """Country or Region."""
    DATE = "Date"
    """Date."""
    DEVICE = "Device"
    """Device ID or serial numbers."""
    DOCTOR = "Doctor"
    """Doctor's Name."""
    EMAIL = "Email"
    """Email Addresses."""
    FAX = "Fax"
    """Fax Number."""
    HEALTH_PLAN = "HealthPlan"
    """Health Plan ID Numbers."""
    HOSPITAL = "Hospital"
    """Hospital Name."""
    I_D_NUM = "IDNum"
    """Id Number, eg. passport number."""
    I_P_ADDRESS = "IPAddress"
    """IP Address."""
    LICENSE = "License"
    """License, eg. Driver's license or medical license."""
    LOCATION_OTHER = "LocationOther"
    """Location Other, eg. Golden Gate Park."""
    MEDICAL_RECORD = "MedicalRecord"
    """Medical Record Number."""
    ORGANIZATION = "Organization"
    """Organization, eg. Microsoft."""
    PATIENT = "Patient"
    """Patient Name."""
    PHONE = "Phone"
    """Phone Number."""
    PROFESSION = "Profession"
    """Profession."""
    SOCIAL_SECURITY = "SocialSecurity"
    """Social Security Number."""
    STATE = "State"
    """State."""
    STREET = "Street"
    """Street."""
    URL = "Url"
    """Web URL."""
    USERNAME = "Username"
    """Usernames, eg. a social media handle."""
    VEHICLE = "Vehicle"
    """Vehicle IDs, eg. license plate or VIN number."""
    ZIP = "Zip"
    """Zip Code."""
